<?php if(Session::has('message')): ?>
    <div class="alert <?php echo e(Session::get('alert-class', 'alert-info')); ?> alert-dismissable">
        <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
        <?php echo e(Session::get('message')); ?>

    </div>
<?php endif; ?>

<?php if(Session::has('notify')): ?>
    <?php
    $message = Session::get('notify.message');
    $alert = Session::get('notify.alert');
    $icon = (Session::get('notify.icon') != null) ? Session::get('notify.icon') : 'fa-check';
    $position = (Session::get('notify.position') != null) ? Session::get('notify.position') : 'top-right';
    $delay = (Session::get('notify.delay') != null) ? Session::get('notify.delay') : '5000';
    ?>
    <script>
        $(function () {
            Notify("<?php echo e($message); ?>", '<?php echo e($position); ?>', '<?php echo e($delay); ?>', '<?php echo e($alert); ?>', '<?php echo e($icon); ?>', true);
        });
    </script>
<?php endif; ?>