<?php
$user = Auth::guard('admin')->user();
$userPersona = \App\Entities\UserPersona::where('user_id', $user->id)->first();
$errorImage = asset('img/profile/' . (($userPersona->persona->genero == 'M') ? "man" : "women") . ".png");
?>
<aside id="sidebar" class="sidebar c-overflow">
    <div class="profile-menu">
        <a href="javascript:;">
            <div class="profile-pic">
                <?php echo e(Html::image(loadPhotoProfile($userPersona->persona->foto, $userPersona->persona->genero), $user->full_name,['onerror'=>"this.src='".$errorImage."'"])); ?>

            </div>

            <div class="profile-info">
                <?php echo e(Auth::guard('admin')->user()->full_name); ?>

                <i class="zmdi zmdi-caret-down"></i>
            </div>
        </a>
        <ul class="main-menu" style="border-bottom: 0;">
            <li>
                <a href="<?php echo e(route("admin.perfil.index")); ?>">
                    <i class="zmdi zmdi-account mdc-text-blue-800"></i>
                    PERFÍL
                </a>
            </li>
            <li>
                <a href="<?php echo e(route("admin.cambiarpassword")); ?>"
                   class=""
                   data-toggle="modal" data-target="#openModal" data-tamanio="sm">
                    <i class="zmdi zmdi-key mdc-text-yellow-800"></i>
                    CAMBIAR CONTRASEÑA
                </a>
            </li>
            <li>
                <a href="<?php echo e(route("admin.logout")); ?>">
                    <i class="zmdi zmdi-power mdc-text-red-800"></i>
                    SALIR
                </a>
            </li>
        </ul>

    </div>
    <ul class="main-menu">
        <li>
            <a href="<?php echo e(route("admin.index")); ?>">
                <i class="zmdi zmdi-home"></i>
                INICIO
            </a>
        </li>
        <li class="d-none">
            <a href="<?php echo e(route("admin.noticias.index")); ?>">
                <i class="zmdi zmdi-notifications mdc-text-indigo-800"></i>
                NOTICIAS
            </a>
        </li>
        <li>
            <a href="<?php echo e(route("admin.tickets.index")); ?>">
                <i class="zmdi zmdi-ticket-star mdc-text-white-dark-800"></i>
                TICKETS
            </a>
        </li>

        <?php /*<li>*/ ?>
        <?php /*<a href="<?php echo e(route("admin.sede.index")); ?>">*/ ?>
        <?php /*<i class="zmdi zmdi-pin mdc-text-deep-purple-800"></i>*/ ?>
        <?php /*SEDE*/ ?>
        <?php /*</a>*/ ?>
        <?php /*</li>*/ ?>
        <?php /*<li>*/ ?>
        <?php /*<a href="<?php echo e(route("admin.area.index")); ?>">*/ ?>
        <?php /*<i class="zmdi zmdi-layers mdc-text-indigo-800"></i>*/ ?>
        <?php /*AREA*/ ?>
        <?php /*</a>*/ ?>
        <?php /*</li>*/ ?>
        <li class="d-none">
            <a href="<?php echo e(route("admin.persona.index")); ?>">
                <i class="zmdi zmdi-account-calendar mdc-text-teal-800"></i>
                PERSONA
            </a>
        </li>
        <li class="d-none">
            <a href="<?php echo e(route("admin.favoritos.index")); ?>">
                <i class="zmdi zmdi-favorite mdc-text-red-800"></i>
                FAVORITOS
            </a>
        </li>
        <li class="d-none">
            <a href="<?php echo e(route("admin.cumpleanios.index")); ?>">
                <i class="zmdi zmdi-cake mdc-text-amber-800"></i>
                CUMPLEAÑOS
            </a>
        </li>

        <li class="d-none">
            <a href="<?php echo e(route("admin.recursoshumanos.index")); ?>">
                <i class="zmdi zmdi-badge-check mdc-text-pink-800"></i>
                RECURSOS HUMANOS
            </a>
        </li>

    </ul>
</aside>