<?php
$user = Auth::guard('superadmin')->user();
?>
<div class="navbar">
    <div class="navbar-inner">
        <div class="navbar-container">
            <div class="navbar-header pull-left">
                <a href="<?php echo e(route('superadmin.index')); ?>" class="navbar-brand">
                    <small>
                        <?php echo e(Html::image('assets/img/cableperu.png')); ?>

                    </small>
                </a>
            </div>
            <div class="sidebar-collapse" id="sidebar-collapse">
                <i class="collapse-icon fa fa-bars"></i>
            </div>
            <div class="navbar-header pull-right">
                <div class="navbar-account">
                    <ul class="account-area">
                        <li style="padding-right: 45px;">
                            <a class="login-area dropdown-toggle" data-toggle="dropdown" style="min-width: 200px;">
                                <div class="avatar avatar-b-left" title="<?php echo e($user->full_name); ?>">
                                    <?php echo e(Html::image('img/likeseasons28.png',$user->full_name,['class'=>'img-radius'])); ?>

                                </div>
                                <section>
                                    <h2>
                                        <span class="profile">
                                            <span><?php echo e($user->full_name); ?></span>
                                        </span>
                                    </h2>
                                </section>
                            </a>

                            <ul class="pull-right dropdown-menu dropdown-arrow dropdown-login-area">
                                <li class="email email-detail" style="color: #000;">
                                    <?php echo e($user->email); ?>

                                </li>
                                <li class="email email-detail" style="color: #000;">
                                    <?php echo e($user->role->description); ?>

                                </li>
                                <li>
                                    <div class="avatar-area">
                                        <?php echo e(Html::image('img/likeseasons28.png',$user->full_name,['class'=>'avatar img-radius'])); ?>

                                    </div>
                                </li>
                                <li class="email email-detail">
                                    <a href="<?php echo e(route('superadmin.password')); ?>"
                                       style="padding: 0;color: #000;font-weight: bold;"
                                       data-toggle="modal"
                                       data-target="#openModal"
                                       data-tamanio="sm">
                                       <i class="fa fa-key color-red"></i> Cambiar Contraseña
                                    </a>
                                </li>
                                <li class="dropdown-footer list-afooter">
                                    <a class="logout-footer" href="<?php echo e(route('superadmin.logout')); ?>"
                                       style="color: #000;font-weight: bold;">
                                        <i class="fa fa-power-off color-red"></i> Cerrar Sesión
                                    </a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                    <div class="setting" style="margin-right: 10px;">
                        <a id="btn-setting" title="Configuracion de Plantilla" href="javascript:;">
                            <i class="icon glyphicon glyphicon-cog"></i>
                        </a>
                    </div>
                    <div class="setting-container" style="width: 520px;">
                        <label>
                            <input type="checkbox" id="checkbox_fixednavbar">
                            <span class="text">Navegación Fijo</span>
                        </label>
                        <label>
                            <input type="checkbox" id="checkbox_fixedsidebar">
                            <span class="text">Menu Fijo</span>
                        </label>
                        <label>
                            <input type="checkbox" id="checkbox_fixedbreadcrumbs">
                            <span class="text">BreadCrumbs Fijo</span>
                        </label>
                        <label>
                            <input type="checkbox" id="checkbox_fixedheader">
                            <span class="text">Titulo Fijo</span>
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<style>
    .img-radius{
        border-radius:50%;
    }
</style>