<?php $__env->startSection('title', 'Noticias'); ?>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.layouts.partials.breadcrumbs', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <span class="d-none spanUrlNoticias" data-url="<?php echo e(route('admin.ajax.dircorpnoticias')); ?>"></span>
    <span class="d-none spanUrlNoticia" data-url="<?php echo e(route('admin.noticias.detalle')); ?>"></span>
    <div class="row d-none" id="dircorpNoticiasEmpty">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-body card-padding text-center">
                    <p class="m-b-0">Aún no se han publicado noticias.</p>
                </div>
            </div>
        </div>
    </div>
    <div class="row grid" id="dircorpNoticias"></div>
    <div class="page-loader-noticia">
        <div class="preloader pls-blue">
            <svg class="pl-circular" viewBox="25 25 50 50">
                <circle class="plc-path" cx="50" cy="50" r="20"/>
            </svg>
            <p>Cargando...</p>
        </div>
    </div>
    <style>
        html:not(.ismobile) .page-loader-noticia {
            background: #fff;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 1001;
        }

        html:not(.ismobile) .page-loader-noticia .preloader {
            width: 50px;
            position: absolute;
            left: 50%;
            margin-left: -25px;
            top: 50%;
            margin-top: -55px;
            -webkit-animation-name: fadeIn;
            animation-name: fadeIn;
            -webkit-animation-duration: 3000ms;
            animation-duration: 3000ms;
            -webkit-animation-fill-mode: both;
            animation-fill-mode: both;
        }

        html:not(.ismobile) .page-loader-noticia .preloader p {
            white-space: nowrap;
            position: relative;
            left: -9px;
            top: 22px;
            color: #CCC;
        }

        .card-header h2 {
            height: 40px;
            margin: 0 auto !important;
            font-size: 15px !important;
            display: block;
            display: -webkit-box;
            line-height: 1.4 !important;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .content-img-post {
            max-height: 180px;
            height: 180px;
            background-size: cover !important;
            background-repeat: no-repeat !important;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(function () {
            $('.page-loader').css('display', 'none');
            var url_ = $('.spanUrlNoticias').data('url');
            var urlNoticia = $('.spanUrlNoticia').data('url');
            $.ajax({
                url: url_,
                type: 'GET',
                dataType: 'json',
                beforeSend: function () {
                },
                success: function (response) {
                    if (response.data.length === 0) {
                        console.log("noticias vacio");
                        $("#dircorpNoticiasEmpty").removeClass("d-none");
                    } else {
                        console.log('response:::', response);
                        var noticias = "";
                        $.each(response.data, function (key, noticia) {
                            noticias += '<div class="grid-item col-md-4">' +
                                '<a class="d-block" href="' + urlNoticia + '/' + noticia.slug + '">' +
                                '<div class="card blog-post">' +
                                '<div class="content-img-post" style="background: url(' + noticia.post_meta_fields.dircorp_noticias_imagen_destacada + ')">' +
                                // '<img src="' + noticia.post_meta_fields.dircorp_noticias_imagen_destacada + '" class="img-responsive" alt="">' +
                                '</div>' +
                                '<div class="card-header">' +
                                '<h2>' + noticia.title.rendered + '</h2>' +
                                '</div>' +
                                // '<div class="card-body card-padding">' + noticia.excerpt.rendered + '</div>' +
                                '</div>' +
                                '</a>' +
                                '</div>';
                        });
                        $("#dircorpNoticias").html(noticias);
                        // $('.grid').masonry({
                        //     // options
                        //     itemSelector: '.grid-item',
                        //     columnWidth: 300,
                        //     gutter: 25
                        // });
                    }
                },
                error: function (err) {
                    console.log("Err:::", err);
                },
                complete: function () {
                    console.log("complete...");
                    setTimeout(function () {
                        $('.page-loader-noticia').css('display', 'none');
                    }, 500);
                }
            });


        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.template', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>