<?php $__env->startSection('title', 'Módulo de Cumpleaños'); ?>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('superadmin.layouts.partials.breadcrumbs', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>
                <i class="zmdi zmdi-cake"></i> Módulo de Cumpleaños
            </h1>
        </div>
        <div class="header-buttons">
            <?php echo $__env->make('superadmin.layouts.partials.headerbuttons', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        </div>
    </div>
    <div class="page-body">
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="row">
                    <?php if(count($personas) > 0): ?>
                        <?php foreach($personas as $persona): ?>
                            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12 <?php echo e(verificaCumple($persona->fecha_nacimiento) ? "animated infinite pulse" : ""); ?>">
                                <a href="<?php echo e(verificaCumple($persona->fecha_nacimiento) ? route('superadmin.cumpleanios.personal.show', [$persona->slug]) : "javascript:;"); ?>"
                                   class="" style=""
                                   data-toggle="modal"
                                   data-target="#openModal"
                                   data-tamanio="sm">
                                    <div class="databox bg-white radius-bordered">
                                        <div class="databox-left no-padding">
                                            <?php echo e(Html::image(loadPhotoProfile($persona->foto,$persona->genero), $persona->apellidos_nombres,['class'=>'img-avatar-cumpleanio'])); ?>

                                        </div>
                                        <div class="databox-right">
                                            <div class="databox-text darkgray ellipsis"><?php echo e($persona->apellidos_nombres); ?></div>
                                            <div class="databox-text darkgray"><?php echo e(dateCarbon($persona->fecha_nacimiento)); ?></div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <style>
        .img-avatar-cumpleanio {
            width: 65px;
            height: 65px;
            padding: 5px;
            border-radius: 50%;
            -webkit-border-radius: 50%;
            -moz-border-radius: 50%;
        }

        /*.ellipsiss {*/
        /*white-space: nowrap;*/
        /*overflow: hidden;*/
        /*text-overflow: ellipsis;*/
        /*}*/
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(function () {
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('superadmin.layouts.template', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>