<?php $__env->startSection('title', 'Módulo de Usuarios'); ?>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('superadmin.layouts.partials.breadcrumbs', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>Módulo de Usuarios</h1>
        </div>
        <div class="header-buttons">
            <?php /*<a class="" href="<?php echo e(route('superadmin.usuarios.create')); ?>"*/ ?>
               <?php /*data-toggle='modal'*/ ?>
               <?php /*data-target="#openModal"*/ ?>
               <?php /*data-tamanio='md'>*/ ?>
                <?php /*<i class="zmdi zmdi-plus-circle"></i>*/ ?>
            <?php /*</a>*/ ?>
            <?php echo $__env->make('superadmin.layouts.partials.headerbuttons', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        </div>
    </div>
    <div class="page-body">
        <div class="row">
            <div class="col-md-12">
                <div class="widget">
                    <div class="widget-header ">
                        <span class="widget-caption">Listado de Usuarios</span>
                        <div class="widget-buttons">
                            <?php echo $__env->make('superadmin.layouts.partials.widgetbutton', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                        </div>
                    </div>
                    <div class="widget-body">
                        <div class="table-responsive row-none" id="resultado_filtro">
                            <table id="tablaListado" class="table table-striped table-bordered table-hover">
                                <thead class="headTablaListado">
                                <tr class="text-uppercase text-center th-head-inputs">
                                    <th>N°</th>
                                    <th>USUARIO</th>
                                    <th>APELLIDOS Y NOMBRES</th>
                                    <th>EMAIL</th>
                                    <th>ROL</th>
                                    <th>ACTIVO</th>
                                    <th>ACCIONES</th>
                                </tr>
                                </thead>
                                <tfoot class="footTablaListado">
                                <tr class="text-uppercase">
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php $n = 1?>
                                <?php foreach($users as $user): ?>
                                    <?php if($user->role_id !=1): ?>
                                        <tr>
                                            <td class="text-center"><?php echo e($n++); ?></td>
                                            <td class="text-center"><?php echo e($user->username); ?></td>
                                            <td class="child-text-delete"><?php echo e($user->last_first_name); ?></td>
                                            <td class="text-left"><?php echo e($user->email); ?></td>
                                            <td class="text-center"><?php echo e($user->role->description); ?></td>
                                            <td class="text-center">
                                                <?php echo verifyActive($user->deleted_at); ?>

                                            </td>
                                            <td class="text-center">

                                                <div class="btn-group">
                                                    <button type="button" class="btn btn-primary dropdown-toggle"
                                                            data-toggle="dropdown">
                                                        Acciones
                                                        <span class="caret"></span>
                                                    </button>
                                                    <ul class="dropdown-menu pull-right" role="menu">
                                                        <li>
                                                            <a href="<?php echo e(route('superadmin.usuarios.show',$user->id)); ?>"
                                                               class=""
                                                               data-toggle='modal'
                                                               data-target="#openModal"
                                                               data-tamanio='lg'>
                                                                <i class="zmdi zmdi-eye"></i>
                                                                Detalle
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="<?php echo e(route('superadmin.usuarios.password',$user->id)); ?>"
                                                               class=""
                                                               data-toggle="modal"
                                                               data-target="#openModal"
                                                               data-tamanio="sm">
                                                                <i class="zmdi zmdi-lock-outline"></i>
                                                                Cambiar Contraseña
                                                            </a>
                                                        </li>
                                                        <?php if($user->deleted_at == null): ?>
                                                            <li>
                                                                <a href="<?php echo e(route('superadmin.usuarios.edit',$user->id)); ?>"
                                                                   class=""
                                                                   data-toggle="modal"
                                                                   data-target="#openModal"
                                                                   data-tamanio="lg">
                                                                    <i class="zmdi zmdi-edit"></i>
                                                                    Editar
                                                                </a>
                                                            </li>
                                                            <li>
                                                                <a href="javascript:;"
                                                                   data-csrf="<?php echo e(csrf_token()); ?>"
                                                                   data-id="<?php echo e($user->id); ?>"
                                                                   data-mensaje="al usuario"
                                                                   data-href="<?php echo e(route('superadmin.usuarios.delete',$user->id)); ?>"
                                                                   class="delete-item">
                                                                    <i class="zmdi zmdi-close"></i>
                                                                    Eliminar
                                                                </a>
                                                            </li>
                                                        <?php else: ?>
                                                            <li>
                                                                <a href="javascript:;"
                                                                   data-csrf="<?php echo e(csrf_token()); ?>"
                                                                   data-id="<?php echo e($user->id); ?>"
                                                                   data-mensaje="al usuario"
                                                                   data-href="<?php echo e(route('superadmin.usuarios.restore',$user->id)); ?>"
                                                                   class="restore-item">
                                                                    <i class="zmdi zmdi-restore-left"></i>
                                                                    Restaurar
                                                                </a>
                                                            </li>
                                                        <?php endif; ?>

                                                    </ul>
                                                </div>


                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(function () {
            tablaListadoDataTable();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('superadmin.layouts.template', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>