<!DOCTYPE html>
<html>
<head lang="es">
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Soporte || Inicio Sesión</title>
    <?php echo $__env->make('layouts.soporte.favicon', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php echo Html::style('support/css/bootstrap.min.css'); ?>

    <?php echo Html::style('support/font-awesome/css/font-awesome.css'); ?>

    <?php echo Html::style('support/css/plugins/toastr/toastr.min.css'); ?>

    <?php echo Html::style('support/css/animate.css'); ?>

    <?php echo Html::style('support/css/style.css'); ?>

    <link href="https://fonts.googleapis.com/css?family=K2D:400,700" rel="stylesheet">
    <style>
        * {
            font-family: 'K2D', sans-serif;
        }

        .loginscreen.middle-box {
            height: 100vh;
            padding-top: calc(10% + 10px);
        }

        .middle-box {
            padding-top: 0;
        }

        .logo-name {
            margin-top: 0;
            font-size: 100px !important;
        }

        .logo-name img {
            width: 100%;
            padding: 10px 20px;
            border-radius: 5px
        }

        @media  screen and (max-width: 360px) {
            .loginscreen.middle-box {
                padding-top: calc(25% + 10px);
            }
        }
    </style>
</head>

<body class="gray-bg">
<div class="middle-box text-center loginscreen animated fadeInDown">
    <div>
        <div><h1 class="logo-name"><?php echo e(Html::image('img/likeseasons.png')); ?></h1></div>
        <h2 style="margin-top: 10px;">Soporte Tecnico</h2>
        <?php echo Form::open(['route'=>'soporte.login','class'=>'m-t','autocomplete'=>'off']); ?>

        <div class="form-group">
            <?php echo Form::text('username',null,['class'=>'form-control input-sm text-lowercase', 'id'=>'username', 'placeholder'=>'Usuario']); ?>

        </div>
        <div class="form-group">
            <?php echo Form::password('password',['class'=>'form-control input-sm', 'id'=>'password', 'placeholder'=>'Contraseña']); ?>

        </div>
        <button type="submit" class="btn btn-primary block full-width m-b">Login</button>
        <?php echo Form::close(); ?>

    </div>
</div>

<?php echo Html::script('support/js/jquery-3.1.1.min.js'); ?>

<?php echo Html::script('support/js/bootstrap.js'); ?>

<?php echo Html::script('support/js/plugins/toastr/toastr.min.js'); ?>

<?php if(count($errors) > 0): ?>
    <script>
        $(function () {
            toastr.error("<?php echo e($errors['message']); ?>", 'DIRCORP...!!!');
        });
    </script>
<?php endif; ?>
</body>
</html>