<!DOCTYPE html>
<html>
<head lang="es">
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dircorp Backend || Login</title>
    <?php echo $__env->make('layouts.superadmin.favicon', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php echo Html::style('css/bootstrap.min.css'); ?>

    <?php echo Html::style('font-awesome/css/font-awesome.css'); ?>

    <?php echo Html::style('css/plugins/toastr/toastr.min.css'); ?>

    <?php echo Html::style('css/animate.css'); ?>

    <?php echo Html::style('css/styles.css'); ?>

    <link href="//fonts.googleapis.com/css?family=K2D:400,700" rel="stylesheet">
    <style>
        *, h1, h2, h3, h4, h5, h6 {
            font-family: 'K2D', sans-serif;
        }

        .loginscreen.middle-box {
            height: 100vh;
            padding-top: calc(10% + 10px);
        }

        .middle-box {
            padding-top: 0;
        }

        .logo-name {
            margin-top: 0;
            font-size: 100px !important;
        }

        .logo-name img {
            width: 100%;
            padding: 10px 20px;
            border-radius: 5px
        }

        .password-control {
            margin-bottom: 15px;
            display: flex;
        }

        .password-control .input-group-append span {
            padding-bottom: 8px;
            cursor: pointer;
        }

        @media  screen and (max-width: 360px) {
            .loginscreen.middle-box {
                padding-top: calc(25% + 10px);
            }
        }
    </style>
</head>

<body class="gray-bg">
<div class="middle-box text-center loginscreen animated fadeInDown">
    <div>
        <div><h1 class="logo-name"><?php echo e(Html::image('https://sig.almoperations.com/public/assets/company/logoalmoperations.png')); ?></h1></div>
        <h3>Administrador de Soporte TI<br>ALM Operations</h3>
        <?php echo Form::open(['route'=>'superadmin.login','class'=>'m-t','autocomplete'=>'off']); ?>

        <div class="form-group">
            <?php echo Form::text('username',null,['class'=>'form-control input-sm text-lowercase', 'id'=>'username', 'placeholder'=>'Usuario']); ?>

        </div>
        <div class="input-group password-control">
            <?php echo Form::password('password',['class'=>'form-control input-sm', 'id'=>'password', 'placeholder'=>'Contraseña']); ?>

            <div class="input-group-append">
                <span class="input-group-addon toggleEye"><i class="fa fa-eye" id="iconEye"></i></span>
            </div>
        </div>
        <div class="form-group">
            <button type="submit" class="btn btn-primary block full-width m-b">Login</button>
        </div>
        <?php echo Form::close(); ?>

    </div>
</div>

<?php echo Html::script('js/jquery-3.1.1.min.js'); ?>

<?php echo Html::script('js/bootstrap.min.js'); ?>

<?php echo Html::script('js/plugins/toastr/toastr.min.js'); ?>

<script>
    $(function () {
        function validateUser(e) {
            var key = (document.all) ? e.keyCode : e.which;
            if (key === 8) return true; // backspace
            if (key < 58 && key > 47) return true;
            var patron = /[a-zA-Z]/; //patron
            var te = String.fromCharCode(key);
            return patron.test(te);
        }

        $(document).on('keypress', '.userValidate', function (e) {
            return validateUser(e);
        });

        $(document).on('click', '.toggleEye', function () {
            var password_ = document.getElementById('password');
            var iconEye_ = $("#iconEye");
            if (password_.type === 'password') {
                password_.type = "text";
                iconEye_.removeClass('fa-eye').addClass('fa-eye-slash');
            } else {
                password_.type = "password";
                iconEye_.removeClass('fa-eye-slash').addClass('fa-eye');
            }
        });
    });
</script>
<?php if(count($errors) > 0): ?>
    <script>
        $(function () {
            toastr.error("<?php echo e($errors['message']); ?>", 'DIRCORP...!!!');
        });
    </script>
<?php endif; ?>
</body>
</html>