<?php $__env->startSection('title', 'Reportes Cumpleaños'); ?>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('superadmin.layouts.partials.breadcrumbs', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>Reporte Cumpleaños</h1>
        </div>
        <div class="header-buttons">
            <a class="fullscreen" id="btnExcelCumpleanioDownload" href="javascript:;">
                <i class="fa fa-file-excel-o"></i>
            </a>
            <?php echo $__env->make('superadmin.layouts.partials.headerbuttons', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        </div>
    </div>
    <div class="page-body">
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <?php echo Form::open(['url'=>'#', 'class'=>'row', 'autocomplete'=>'off']); ?>

                <div class="col-md-3 col-sm-3">
                    <div class="form-group fg-line">
                        <?php echo Form::label('mes_id', 'Mes', ['class' => '']); ?>

                        <?php echo Form::select('mes_id', $meses, null, ['class'=>'form-control input-sm select','id'=>'mes_id','placeholder'=>'Seleccione']); ?>

                    </div>
                </div>
                <span class="ruta-cumpleanio-filtro"
                      data-url="<?php echo e(route('superadmin.herramientas.reportes.cumpleanios.filtromes')); ?>"></span>
                <div class="col-sm-3 col-md-3" style="position: relative;top: 24px;">
                    <div class="form-group fg-line">
                        <button type="button" class="btn btn-primary btnFiltrarMes">
                            <i class="zmdi zmdi-filter-list"></i> FILTRAR
                        </button>
                    </div>
                </div>
                <?php echo Form::close(); ?>

            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="widget">
                    <div class="widget-header ">
                        <span class="widget-caption">Listado de Cumpleaños</span>
                    </div>
                    <div class="widget-body">
                        <div class="table-responsive row-none" id="resultado_filtro">
                            <table id="tablaListado" class="table table-striped table-bordered table-hover">
                                <thead class="headTablaListado">
                                <tr class="text-uppercase text-center th-head-inputs">
                                    <th>N°</th>
                                    <th>Foto</th>
                                    <th>Apellidos y Nombres</th>
                                    <th>Cargo</th>
                                    <th>Cumpleaño</th>
                                </tr>
                                </thead>
                                <tfoot class="footTablaListado">
                                <tr class="text-uppercase">
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php $n = 1;?>
                                <?php foreach($personas as $persona): ?>
                                    <tr>
                                        <td class="text-center"><?php echo e($n++); ?></td>
                                        <td class="text-center"><?php echo e(Html::image(loadPhotoProfile($persona->foto,$persona->genero), $persona->apellidos_nombres,['class'=>'img-avatar-cumpleanio'])); ?></td>
                                        <td class="text-left"><?php echo e($persona->apellidos_nombres); ?></td>
                                        <td class="text-left"><?php echo e($persona->cargo->nombre); ?></td>
                                        <td class="text-left"><?php echo e(dateCarbon($persona->fecha_nacimiento)); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <style>
        .img-avatar-cumpleanio {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            -webkit-border-radius: 50%;
            -moz-border-radius: 50%;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(function () {

            tablaListadoDataTable();

            $(document).on('click', "#btnExcelCumpleanioDownload", function () {
                var button = $(this);
                var mes_id = $("#mes_id").val();
                if (mes_id !== '') {
                    var url = $('.ruta-cumpleanio-filtro').data('url') + '/' + mes_id;
                    console.log("ruta:::", url);
                    button.attr('href', url);

                    setTimeout(function () {
                        button.click();
                    }, 200);

                } else {
                    console.log("Seleccione una mes para exportar");
                    notifyAlert('Seleccione una mes para exportar.', 'bottom-left', 'danger');
                }

            });

            function loadCumpleanioMes(mes_id) {
                $("#toast-container").remove();
                if (mes_id !== "") {
                    var url = $('.ruta-cumpleanio-filtro').data('url');
                    var data = {
                        mes: mes_id
                    };
                    console.log("data::: ", data);
                    console.log("url::: ", url);
                    $.ajax({
                        url: url,
                        type: 'GET',
                        dataType: 'json',
                        data: data,
                        beforeSend: function () {
                            $('.loading-container').css('display', 'block');
                            $('.loading-container .loader').css('display', 'block');
                        },
                        success: function (response) {
                            console.log("response::: ", response);
                            llenar(response.data);
                            notifyAlert(response.message, 'bottom-right', response.status);
                        },
                        error: function (err) {
                            console.log("show_error_err: ", err);
                            console.log("show_error_errResponseText: ", err.responseText);
                        },
                        complete: function () {
                            $('.loading-container').css('display', 'none');
                            $('.loading-container .loader').css('display', 'none');
                        }
                    });
                } else {
                    console.log("Seleccione una opción:::");
                    notifyAlert('Seleccione una opción.', 'bottom-left', 'danger');
                }
            }

            $(document).on('click', '.btnFiltrarMes', function () {
                var mes_id = $("#mes_id").val();
                loadCumpleanioMes(mes_id);
            });

            function llenar(response) {
                var tableId = $("#tablaListado");
                var table = tableId.DataTable({
                    destroy: true,
                    data: response,
                    columns: [
                        {"data": "correlativo"},
                        {"data": "foto"},
                        {"data": "apellidos_nombres"},
                        {"data": "cargo_nombre"},
                        {"data": "cumpleanio"}
                    ],
                    language: {
                        "sSearch": "",
                        "searchPlaceholder": "Buscar...",
                        "sLengthMenu": 'Mostrando <select class="form-control input-sm select">' +
                        '<option value="10">10</option>' +
                        '<option value="20">20</option>' +
                        '<option value="30">30</option>' +
                        '<option value="40">40</option>' +
                        '<option value="50">50</option>' +
                        '<option value="-1">Todos</option>' +
                        '</select> registros',
                        "oPaginate": {
                            "sFirst": "<i class='fa fa-angle-double-left'></i>",
                            "sLast": "<i class='fa fa-angle-double-right'></i>",
                            "sNext": "<i class='fa fa-angle-right'></i>",
                            "sPrevious": "<i class='fa fa-angle-left'></i>"
                        },
                        "sInfoEmpty": "0 registros que mostrar",
                        "sInfoFiltered": " ",
                        "sZeroRecords": "<div class='text-center'><i class='zmdi zmdi-mood-bad zmdi-hc-5x'></i><h3>No hay registro que mostrar</h3></div>",
                        "sLoadingRecords": "Por favor espere - cargando...",
                        "sInfo": "Mostrando _START_ de _END_ registros, Total _TOTAL_ registros"
                    },
                    columnDefs: [
                        {"className": "text-center", "targets": [0, 1]}
                    ]
                });
                table.columns().eq(0).each(function (colIdx) {
                    $('input', table.column(colIdx).footer()).on('keyup change', function () {
                        table.column(colIdx).search(this.value).draw();
                    });
                });
            }

        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('superadmin.layouts.template', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>