<?php $__env->startSection('title', 'Detalle'); ?>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.layouts.partials.breadcrumbs', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <span class="d-none spanUrlNoticia" data-url="<?php echo e(route('admin.ajax.dircorpnoticiasdetalle')); ?>"></span>
    <span class="d-none spanUrlOtherNoticia" data-url="<?php echo e(route('admin.noticias.detalle')); ?>"></span>
    <div class="row wall">
        <div class="col-md-8" id="dircorpNoticia"></div>
        <div class="col-md-4 hidden-sm hidden-xs ">
            <div class="card d-none" id="dircorpNoticias">
                <div class="card-header">
                    <h2>Noticias recientes
                        <?php /*<small>Commodo vel pharetra nisi. Donec velit libero</small>*/ ?>
                    </h2>
                </div>

                <div class="listview">
                    <div class="lv-body" id="dircorpNoticiasLista"></div>
                </div>
            </div>
        </div>
    </div>
    <div class="page-loader-noticia">
        <div class="preloader pls-blue">
            <svg class="pl-circular" viewBox="25 25 50 50">
                <circle class="plc-path" cx="50" cy="50" r="20"/>
            </svg>
            <p>Cargando...</p>
        </div>
    </div>
    <style>
        html:not(.ismobile) .page-loader-noticia {
            background: #fff;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 1001;
        }

        html:not(.ismobile) .page-loader-noticia .preloader {
            width: 50px;
            position: absolute;
            left: 50%;
            margin-left: -25px;
            top: 50%;
            margin-top: -55px;
            -webkit-animation-name: fadeIn;
            animation-name: fadeIn;
            -webkit-animation-duration: 3000ms;
            animation-duration: 3000ms;
            -webkit-animation-fill-mode: both;
            animation-fill-mode: both;
        }

        html:not(.ismobile) .page-loader-noticia .preloader p {
            white-space: nowrap;
            position: relative;
            left: -9px;
            top: 22px;
            color: #CCC;
        }

        #dircorpNoticia {

        }

        #dircorpNoticia img {
            max-width: 100%;
            height: 100%;
        }

        #dircorpNoticia iframe {
            max-width: 100%;
            max-height: 300px;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(function () {
            $('.page-loader').css('display', 'none');
            var url_ = $('.spanUrlNoticia').data('url') + "/" + "<?php echo e($slug); ?>";
            console.log("url_:::", url_);
            $.ajax({
                url: url_,
                type: 'GET',
                dataType: 'json',
                beforeSend: function () {
                },
                success: function (response) {
                    moment.locale('es');
                    console.log('response:::', response);
                    if (response.noticia === null) {
                        console.log("noticia vacio");
                        window.location.href = response.route;
                    } else {
                        var urlNoticia = $('.spanUrlOtherNoticia').data('url');
                        var noticia = response.noticia;
                        var fecha_ = moment(noticia.date).format('DD [de] MMMM [del] YYYY [a las] h:mm:ss a');
                        var divNoticia = "";
                        divNoticia += '<div class="card w-item">' +
                            '<div class="card-header">' +
                            '<div class="media">' +
                            '<div class="media-body">' +
                            '<h2>' + noticia.title.rendered + '<small>Publicado el ' + fecha_ + '</small></h2>' +
                            '</div>' +
                            '</div>' +
                            '</div>' +
                            '<div class="card-body card-padding">' + noticia.content.rendered + '</div>' +
                            '</div>';
                        $("#dircorpNoticia").html(divNoticia);

                        var noticias = "";
                        $.each(response.noticias, function (key, notice) {
                            noticias += '<a class="lv-item" href="' + urlNoticia + '/' + notice.slug + '">' +
                                '<div class="media">' +
                                '<div class="pull-left">' +
                                '<img class="lv-img-sm" src="' + notice.post_meta_fields.dircorp_noticias_imagen_destacada + '" alt="">' +
                                '</div>' +
                                '<div class="media-body">' +
                                '<div class="lv-title">' + notice.title.rendered + '</div>' +
                                '</div>' +
                                '</div>' +
                                '</a>';
                        });
                        $("#dircorpNoticiasLista").html(noticias);
                    }
                },
                error: function (err) {
                    console.log("Err:::", err);
                },
                complete: function () {
                    console.log("complete...");
                    $("#dircorpNoticias").removeClass('d-none');
                    setTimeout(function () {
                        console.log("que pasooooooo");
                        $('.page-loader-noticia').css('display', 'none');
                    }, 500);
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.template', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>