<?php $__env->startSection('title', 'Perfíl'); ?>
<?php $__env->startSection('content'); ?>
    <?php /*<?php echo $__env->make('admin.layouts.partials.breadcrumbs', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>*/ ?>
    <div class="card" id="profile-main">
        <?php echo $__env->make('admin.personas.perfil.partials.profile', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        <div class="pm-body clearfix">

            <ul class="tab-nav tn-justified">
                <li class="active waves-effect"><a href="<?php echo e(route('admin.perfil.index')); ?>">INFORMACIÓN</a></li>
                <li class="waves-effect"><a href="<?php echo e(route('admin.perfil.cumpleanio')); ?>">SALUDOS</a></li>
            </ul>

            <div class="pmb-block">
                <div class="pmbb-header">
                    <h2><i class="zmdi zmdi-account m-r-5"></i> Información Basica</h2>
                    <ul class="actions">
                        <li class="dropdown">
                            <a href="#" data-toggle="dropdown">
                                <i class="zmdi zmdi-more-vert"></i>
                            </a>

                            <ul class="dropdown-menu dropdown-menu-right">
                                <li>
                                    <a data-pmb-action="edit" href="#">Editar</a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </div>
                <div class="pmbb-body p-l-30">
                    <div class="pmbb-view">
                        <dl class="dl-horizontal">
                            <dt>Apellidos y Nombres</dt>
                            <dd><?php echo e(existsContent($persona->apellidos_nombres)); ?></dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Genero</dt>
                            <dd><?php echo e(existsContent($persona->genero)); ?></dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Cumpleaños</dt>
                            <dd class="text-uppercase">
                                <?php echo e(($persona->fecha_nacimiento != null ) ? dateCarbon(formatDate($persona->fecha_nacimiento)) : "-"); ?>

                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Estado Civil</dt>
                            <dd class="text-uppercase"><?php echo e(existsContent($persona->estado_civil)); ?></dd>
                        </dl>
                    </div>
                    <?php echo Form::model($persona, ['route'=>['admin.perfil.update.basic', $persona->id], 'class'=>'formAjaxPerfilBasica']); ?>

                    <div class="pmbb-edit">
                        <dl class="dl-horizontal">
                            <dt class="p-t-10">Apellidos y Nombres</dt>
                            <dd>
                                <div class="fg-line">
                                    <?php echo Form::text('apellidos_nombres',(isset($persona) ? $persona->apellidos_nombres : null),['class'=>'form-control','id'=>'apellidos_nombres','placeholder'=>'Apellidos y Nombres']); ?>

                                </div>
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt class="p-t-10">Genero</dt>
                            <dd>
                                <div class="fg-line">
                                    <?php echo Form::select('genero', $genero, (isset($persona) ? $persona->genero : null), ['id'=>'genero', 'class'=>'form-control select']); ?>

                                </div>
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt class="p-t-10">Fecha Nacimiento</dt>
                            <dd>
                                <div class="dtp-container dropdown fg-line">
                                    <?php echo Form::text('fecha_nacimiento',(isset($persona) ? $persona->fecha_nacimiento : null),['class'=>'form-control', 'data-toggle'=>'dropdown', 'id'=>'fecha_nacimiento','placeholder'=>'Clic Aquí...']); ?>

                                </div>
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt class="p-t-10">Estado Civil</dt>
                            <dd>
                                <div class="fg-line">
                                    <?php echo Form::select('estado_civil', $estadoCivil, (isset($persona) ? $persona->estado_civil : null), ['id'=>'estado_civil', 'class'=>'form-control select']); ?>

                                </div>
                            </dd>
                        </dl>

                        <div class="m-t-30">
                            <button class="btn btn-success btn-sm btnSubmitFormPerfilBasica" type="submit">Guardar
                            </button>
                            <button data-pmb-action="reset" class="btn btn-danger btn-sm">Cancelar</button>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>


                </div>
            </div>

            <div class="pmb-block">
                <div class="pmbb-header">
                    <h2><i class="zmdi zmdi-phone m-r-5"></i> Información Contacto</h2>
                    <ul class="actions">
                        <li class="dropdown">
                            <a href="#" data-toggle="dropdown">
                                <i class="zmdi zmdi-more-vert"></i>
                            </a>

                            <ul class="dropdown-menu dropdown-menu-right">
                                <li>
                                    <a data-pmb-action="edit" href="#">Editar</a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </div>
                <div class="pmbb-body p-l-30">
                    <div class="pmbb-view">
                        <dl class="dl-horizontal">
                            <dt>Sede</dt>
                            <dd><?php echo e($persona->sede->nombre); ?></dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Área</dt>
                            <dd><?php echo e($persona->area->nombre); ?></dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Cargo</dt>
                            <dd><?php echo e($persona->cargo->nombre); ?></dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>E-Mail</dt>
                            <dd>
                                <?php if($persona->email != null || $persona->email != ""): ?>
                                    <a href="mailto:<?php echo e($persona->email); ?>?subject=Saludos%20<?php echo e(encodeUriComponent($persona->nombre_apellido)); ?>&body=Hola,%0A%0A<?php echo e(encodeUriComponent('El motivo de este mensaje es el siguiente:')); ?>"
                                       target="_blank">
                                        <?php echo e($persona->email); ?>

                                    </a>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Teléfono Empresa</dt>
                            <dd>
                                <?php if($persona->telefono_empresa != null || $persona->telefono_empresa != ""): ?>
                                    <a href="tel:<?php echo e(encodeUriComponent($persona->telefono_empresa)); ?> ">
                                        <?php echo e($persona->telefono_empresa); ?>

                                    </a>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Anexo</dt>
                            <dd><?php echo e(existsContent($persona->anexo)); ?></dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Telefono Personal</dt>
                            <dd>
                                <?php if($persona->telefono_personal != null || $persona->telefono_personal != ""): ?>
                                    <a href="tel:<?php echo e(encodeUriComponent($persona->telefono_personal)); ?> ">
                                        <?php echo e($persona->telefono_personal); ?>

                                    </a>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </dd>
                        </dl>
                    </div>
                    <?php echo Form::model($persona, ['route'=>['admin.perfil.update.contact', $persona->id], 'class'=>'formAjaxPerfilContact']); ?>

                    <div class="pmbb-edit">
                        <dl class="dl-horizontal">
                            <dt class="p-t-10">E-Mail</dt>
                            <dd>
                                <div class="fg-line">
                                    <?php echo Form::email('email',(isset($persona) ? $persona->email : null),['class'=>'form-control','id'=>'email','placeholder'=>'E-Mail']); ?>

                                </div>
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt class="p-t-10">Teléfono Empresa</dt>
                            <dd>
                                <div class="fg-line">
                                    <?php echo Form::text('telefono_empresa',(isset($persona) ? $persona->telefono_empresa : null),['class'=>'form-control onlyNumber','id'=>'telefono_empresa','placeholder'=>'Teléfono Empresa','maxlength'=>9]); ?>

                                </div>
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt class="p-t-10">Anexo</dt>
                            <dd>
                                <div class="fg-line">
                                    <?php echo Form::text('anexo',(isset($persona) ? $persona->anexo : null),['class'=>'form-control onlyNumber','id'=>'anexo','placeholder'=>'Anexo','maxlength'=>4]); ?>

                                </div>
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt class="p-t-10">Teléfono Personal</dt>
                            <dd>
                                <div class="fg-line">
                                    <?php echo Form::text('telefono_personal',(isset($persona) ? $persona->telefono_personal : null),['class'=>'form-control onlyNumber','id'=>'telefono_personal','placeholder'=>'Teléfono Personal','maxlength'=>9]); ?>

                                </div>
                            </dd>
                        </dl>
                        <div class="m-t-30">
                            <button class="btn btn-success btn-sm btnSubmitFormPerfilContact" type="submit">Guardar
                            </button>
                            <button data-pmb-action="reset" class="btn btn-danger btn-sm">Cancelar</button>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>


                </div>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(function () {
            $("#fecha_nacimiento").datetimepicker({
                format: 'DD-MM-YYYY',
                locale: 'es'
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.template', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>