<?php $__env->startSection('title', 'Favoritos'); ?>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.layouts.partials.breadcrumbs', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php if(count($favoritos) > 0): ?>
        <div class="card">
            <div class="lv-header-alt clearfix m-b-5">
                <h2 class="lvh-label hidden-xs">Escriba el nombre</h2>
                <div class="lvh-search" style="display:block">
                    <input type="search" id="searchPersona" placeholder="Filtra nombre..." class="lvhs-input">
                    <i class="lvh-search-close close-search">&times;</i>
                </div>
            </div>

            <div class="card-body card-padding">
                <div class="contacts clearfix row"  style="padding-top: 20px;">
                    <?php foreach($favoritos as $favorito): ?>
                        <?php $errorImage = asset('img/profile/' . (($favorito->persona->genero == 'M') ? "man" : "women") . ".png"); ?>
                        <div class="col-md-2 col-sm-4 col-xs-6 listadoPersona">
                            <a href="<?php echo e(route('admin.persona.detalle',$favorito->persona->slug)); ?>" class="ci-avatar" style="display: block;">
                                <div class="c-item">
                                    <div class="ci-avatar show-photo-profile-radius">
                                        <?php echo e(Html::image(loadPhotoProfile($favorito->persona->foto,$favorito->persona->genero), $favorito->persona->apellidos_nombres,['class'=>'p-10','onerror'=>"this.src='".$errorImage."'"])); ?>

                                    </div>

                                    <div class="c-info">
                                        <strong><?php echo e($favorito->persona->apellidos_nombres); ?></strong>
                                        <?php /*<small><i class="zmdi zmdi-favorite-outline"></i> Dejar de seguir</small>*/ ?>
                                    </div>

                                    <div class="c-footer">
                                        <button class="waves-effect"><i class="zmdi zmdi-eye"></i></button>
                                    </div>
                                </div>
                            </a>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body card-padding">
                        <p>Aún no has añadido favoritos, comienza buscando a una persona y agregalo</p>
                        <a href="<?php echo e(route('admin.persona.index')); ?>" class="btn btn-warning btn-icon-text">
                            <i class="zmdi zmdi-arrow-back"></i> Agregar persona
                        </a>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.template', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>