<?php $__env->startSection('title', 'Módulo de Listas'); ?>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('superadmin.layouts.partials.breadcrumbs', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>Módulo de Listas</h1>
        </div>
        <div class="header-buttons">
            <a class="add-user" href="<?php echo e(route('superadmin.herramientas.listas.crear')); ?>"
               data-toggle="modal"
               data-target="#openModal"
               data-tamanio="sm">
                <i class="zmdi zmdi-plus-circle"></i>
            </a>
            <?php echo $__env->make('superadmin.layouts.partials.headerbuttons', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        </div>
    </div>
    <div class="page-body">
        <div class="row">
            <div class="col-md-12">
                <div class="widget">
                    <div class="widget-header ">
                        <span class="widget-caption">Módulo de Listas</span>
                        <div class="widget-buttons">
                            <?php echo $__env->make('superadmin.layouts.partials.widgetbutton', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                        </div>
                    </div>
                    <div class="widget-body">
                        <div class="table-responsive row-none" id="resultado_filtro">
                            <table id="tablaListado" class="table table-striped table-bordered table-hover">
                                <thead class="headTablaListado">
                                <tr class="text-uppercase text-center th-head-inputs">
                                    <th>N°</th>
                                    <th>Lista</th>
                                    <th>DESCRIPCIÓN</th>
                                    <th>Sub Listas</th>
                                    <th>Acciones</th>
                                </tr>
                                </thead>
                                <tfoot class="footTablaListado">
                                <tr class="text-uppercase">
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php $n = 1?>
                                <?php foreach($listas as $lista): ?>
                                    <tr>
                                        <td class="text-center"><?php echo e($n++); ?></td>
                                        <td class=""><?php echo e($lista->nombre); ?></td>
                                        <td class=""><?php echo e($lista->descripcion); ?></td>
                                        <td class="text-center">
                                            <a href="<?php echo e(route('superadmin.herramientas.listas.sublista.index',$lista->slug)); ?>"
                                               class="btn btn-purple shiny btn-circle btn-xs">
                                                <?php echo e($lista->sub_listas_count); ?>

                                            </a>
                                        </td>
                                        <td class="text-center">
                                            <div class="btn-group">
                                                <a class="btn btn-primary dropdown-toggle btn-sm"
                                                   data-toggle="dropdown">
                                                    Acciones <i class="fa fa-angle-down"></i>
                                                </a>
                                                <ul class="dropdown-menu pull-right">
                                                    <li>
                                                        <a href="<?php echo e(route('superadmin.herramientas.listas.editar', [$lista->slug])); ?>"
                                                           class=""
                                                           data-toggle='modal'
                                                           data-target="#openModal"
                                                           data-tamanio='sm'>
                                                            <i class="zmdi zmdi-edit"></i>
                                                            Editar
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(function () {
            tablaListadoDataTable();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('superadmin.layouts.template', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>