<?php #$userRole = Auth::guard('soporte')->user()->role_id; ?>

<?php $__env->startSection('title', 'Inicio'); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-lg-3">
            <div class="ibox ">
                <div class="ibox-title pendientes">
                    <span class="label text-warning float-right"><i class="zmdi zmdi-notifications"></i></span>
                    <h5>Pendientes</h5>
                </div>
                <div class="ibox-content">
                    <h1 class="no-margins"><?php echo e(isset($reportEasyTickets['pendientes']) ? $reportEasyTickets['pendientes']['cantidad'] : 0); ?></h1>
                    <div class="stat-percent font-bold text-warning"><?php echo e(isset($reportEasyTickets['pendientes']) ? $reportEasyTickets['pendientes']['porcentaje'] : '0'); ?>

                        %
                    </div>
                    <small>&nbsp;</small>
                </div>
            </div>
        </div>
        <div class="col-lg-3">
            <div class="ibox ">
                <div class="ibox-title asignados">
                    <span class="label text-success float-right"><i class="zmdi zmdi-account-circle"></i></span>
                    <h5>Asignados</h5>
                </div>
                <div class="ibox-content">
                    <h1 class="no-margins"><?php echo e(isset($reportEasyTickets['asignados']) ? $reportEasyTickets['asignados']['cantidad'] : 0); ?></h1>
                    <div class="stat-percent font-bold text-success"><?php echo e(isset($reportEasyTickets['asignados']) ? $reportEasyTickets['asignados']['porcentaje'] : '0'); ?>

                        %
                    </div>
                    <small>&nbsp;</small>
                </div>
            </div>
        </div>
        <div class="col-lg-3">
            <div class="ibox ">
                <div class="ibox-title con-incidencias">
                    <span class="label text-danger float-right"><i class="zmdi zmdi-fire"></i></span>
                    <h5>Con Incidencias</h5>
                </div>
                <div class="ibox-content">
                    <h1 class="no-margins"><?php echo e(isset($reportEasyTickets['conIncidencias']) ? $reportEasyTickets['conIncidencias']['cantidad'] : 0); ?></h1>
                    <div class="stat-percent font-bold text-danger"><?php echo e(isset($reportEasyTickets['conIncidencias']) ? $reportEasyTickets['conIncidencias']['porcentaje'] : '0'); ?>

                        %
                    </div>
                    <small>&nbsp;</small>
                </div>
            </div>
        </div>
        <div class="col-lg-3">
            <div class="ibox ">
                <div class="ibox-title atendidos">
                    <span class="label text-atendidos float-right"><i class="zmdi zmdi-check-circle"></i></span>
                    <h5>Atendidos</h5>
                </div>
                <div class="ibox-content">
                    <h1 class="no-margins"><?php echo e(isset($reportEasyTickets['atendidos']) ? $reportEasyTickets['atendidos']['cantidad'] : 0); ?></h1>
                    <div class="stat-percent font-bold text-atendidos"><?php echo e(isset($reportEasyTickets['atendidos']) ? $reportEasyTickets['atendidos']['porcentaje'] : '0'); ?>

                        %
                    </div>
                    <small>&nbsp;</small>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-3">
            <div class="ibox ">
                <div class="ibox-title">
                    <h5>Nuevos Pendientes</h5>
                    <?php echo $__env->make('soporte.layouts.partials.widgetbutton', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                </div>
                <?php if(count($ticketsPendientes)==0): ?>
                    <div class="ibox-content ibox-heading">
                        <h4>No hay pendientes</h4>
                    </div>
                <?php else: ?>
                    <div class="ibox-content">
                        <div class="feed-activity-list">
                            <?php foreach($ticketsPendientes as $ticket): ?>
                                <div class="feed-element">
                                    <a class="listado-nuevos-pendientes d-block"
                                       href="<?php echo e(route('soporte.tickets.detalle', $ticket->ticket->codigo)); ?>">
                                        <small class="float-right text-warning timeAgoTicketPendiente"
                                               style="font-weight: bold"></small>
                                        <strong><?php echo e($ticket->persona->apellidos_nombres); ?></strong>
                                        <div>#<?php echo e($ticket->ticket->codigo); ?></div>
                                        <div><?php echo e($ticket->ticket->asunto); ?></div>
                                        <span class="d-none moment-tickets-pendientes"><?php echo e($ticket->fecha_inicio_pendiente); ?></span>
                                        <small class="text-muted "><?php echo e(dateTicketCarbon($ticket->fecha_inicio_pendiente)); ?></small>
                                    </a>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="col-lg-9">
            <div class="ibox ">
                <div class="ibox-title">
                    <h5>Tickets</h5>
                    <?php echo $__env->make('soporte.layouts.partials.widgetbutton', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                </div>
                <div class="ibox-content">
                    <?php echo Form::open(['url'=>'#', 'class'=>'row soporteTickets', 'autocomplete'=>'off']); ?>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <?php echo Form::label('date_range_time', 'Rango Fechas', ['class' => '']); ?>

                            <?php echo Form::text('date_range_time',($firstDay.' - '.$lastDay),['class'=>'form-control form-control-sm','id'=>'date_range_time','placeholder'=>'Rango de Fechas']); ?>

                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <?php echo Form::label('estado_ticket', 'Estado', ['class' => '']); ?>

                            <?php echo Form::select('estado_ticket', $estadoTickets, null, ['id'=>'estado_ticket', 'class'=>'select2 form-control-sm','placeholder'=>'Seleccione Estado']); ?>

                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <?php echo Form::label('codigo', '# Ticket', ['class' => '']); ?>

                            <?php echo Form::text('codigo',null,['class'=>'form-control form-control-sm','id'=>'codigo','placeholder'=>'# Ticket']); ?>

                        </div>
                    </div>
                    <div class="col-sm-2">
                        <button type="button" class="btn btn-sm btn-primary" id="btnFiltroTickets">
                            <i class="zmdi zmdi-filter-list"></i> Filtrar
                        </button>
                    </div>
                    <?php echo e(Form::close()); ?>


                    <div class="table-responsive" id="resultado_filtro">
                        <table id="tablaListado" class="table table-hover no-margins">
                            <thead>
                            <tr class="text-uppercase">
                                <th>#Ticket</th>
                                <th>Fecha</th>
                                <th>Técnico</th>
                                <th>Acciones</th>
                            </tr>
                            </thead>
                            <tbody id="bodyTickets">
                            <?php $__empty_1 = true; foreach($ticketEstados as $ticketEstado): $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <span>
                                            <i class="zmdi zmdi-account"></i>
                                            <?php echo e($ticketEstado->persona->apellidos_nombres); ?>

                                        </span>

                                        <span style="display: block;margin-bottom: .5rem;margin-top: .5rem;"
                                              class="child-text-delete">#<?php echo e($ticketEstado->ticket->codigo); ?></span>
                                        <small style="border-radius: 8px;"
                                               class="label label-<?php echo e($ticketEstado->estadoTicket['color']); ?>"><?php echo e($ticketEstado->estadoTicket['message']); ?></small>
                                    </td>
                                    <td>
                                        <span class="d-none moment-tickets-listado"><?php echo e($ticketEstado->estadoTicketFecha); ?></span>
                                        <i class="fa fa-clock-o"></i> <?php echo e(fechaEstadoTicket($ticketEstado->estadoTicketFecha)); ?>

                                        <br>
                                        <small class="text-warning timeAgoTicketListado"
                                               style="font-weight: bold;font-size: 1em;"></small>
                                    </td>
                                    <td><?php echo tecnicoTicket($ticketEstado->tecnico); ?></td>
                                    <td class="text-navy td-a">
                                        <a href="<?php echo e(route('soporte.tickets.detalle', $ticketEstado->ticket->codigo)); ?>"
                                           class="btn btn-primary">
                                            <i class="zmdi zmdi-eye"></i>
                                        </a>
                                        <?php if($ticketEstado->estadoTicket['message'] != "Atendido"): ?>
                                            <a href="javascript:;"
                                               data-csrf="<?php echo e(csrf_token()); ?>"
                                               data-id="<?php echo e($ticketEstado->ticket_id); ?>"
                                               data-mensaje="el ticket"
                                               data-href="<?php echo e(route('soporte.tickets.delete',$ticketEstado->ticket_id)); ?>"
                                               class="delete-item btn btn-danger">
                                                <i class="zmdi zmdi-close"></i>
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4">No hay coincidencias</td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <span class="urlFiltroTickets" data-url="<?php echo e(route('soporte.ajax.filtro.tickets')); ?>"></span>
    </div>
    <style type="text/css">

        .td-a a {
            margin-right: 5px;
        }

        .soporteTickets #estado_ticket {
            width: 100%;
        }

        .soporteTickets .select2-container .select2-selection--single {
            height: 32px;
        }

        .soporteTickets .select2-container--default .select2-selection--single {
            -webkit-border-radius: 0px;
            -moz-border-radius: 0px;
            border-radius: 0px;
        }

        .swal2-container .swal2-modal {
            border-radius: 4px;
        }

        .swal2-container .swal2-modal .swal2-content {
            color: #777;
            font-size: 13px;
            font-weight: 400;
        }

        .swal2-container .swal2-buttonswrapper button.swal2-cancel,
        .swal2-container .swal2-buttonswrapper button.swal2-confirm {
            border-radius: 4px;
            font-size: 12px;
            text-transform: uppercase;
            font-weight: 400;
            font-family: inherit;
            padding: 6px 12px;
            margin: 0 5px;
            letter-spacing: 0.5px;
        }

        .tecnicoColor {
            color: #fff;
            padding: 6px;
            -webkit-border-radius: 10px;
            -moz-border-radius: 10px;
            border-radius: 10px;
            font-size: 0.89em;
            letter-spacing: 1px;
        }

        .ibox-title {
            padding: 12px 8px 8px 15px;
        }

        .ibox-title span.label {
            margin-right: 0;
            margin-left: 0;
            font-size: 1.3rem;
            background-color: #fff;
        }

        .ibox-title.pendientes {
            border-color: #f8ac59;
        }

        .ibox-title.asignados {
            border-color: #1c84c6;
        }

        .ibox-title.con-incidencias {
            border-color: #ed5565;
        }

        .ibox-title.atendidos {
            border-color: #1ab394;
        }

        .text-atendidos {
            color: #1ab394;
        }

        a.listado-nuevos-pendientes {
            color: inherit;
        }

        a.listado-nuevos-pendientes:hover,
        a.listado-nuevos-pendientes:hover div,
        a.listado-nuevos-pendientes:hover small.text-muted {
            color: #37474F !important;
        }

        .table > thead > tr > th, .table > tbody > tr > th, .table > tfoot > tr > th, .table > thead > tr > td, .table > tbody > tr > td, .table > tfoot > tr > td {
            vertical-align: middle;
        }

        .table > tbody > tr > td {
            font-size: 0.89em;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(function () {
            moment.locale('es');
            $(".select2").select2({
                placeholder: "Seleccione Estado",
                // allowClear: true
            });

            $('#date_range_time').daterangepicker({
                format: 'DD-MM-YYYY',
                locale: {
                    applyLabel: "Aplicar",
                    cancelLabel: "Cancelar",
                    fromLabel: "Desde",
                    toLabel: "Hasta",
                    customRangeLabel: "Custom",
                    daysOfWeek: [
                        'Dom',
                        'Lun',
                        'Mar',
                        'Mie',
                        'Jue',
                        'Vie',
                        'Sáb'
                    ],
                    monthNames: [
                        'Enero',
                        'Febrero',
                        'Marzo',
                        'Abril',
                        'Mayo',
                        'Junio',
                        'Julio',
                        'Agosto',
                        'Setiembre',
                        'Outubre',
                        'Noviembre',
                        'Diciembre'
                    ],
                    firstDay: 1
                },
                opens: 'left',
                drops: 'down',
                buttonClasses: 'btn btn-sm',
                applyClass: 'btn-success',
                cancelClass: 'btn-default'
            });

            var hour_moment = $('.moment-tickets-pendientes');
            $(hour_moment).each(function (i, item) {
                $('.timeAgoTicketPendiente')[i].innerHTML = moment($(this).text(), "YYYY-MM-DD HH:mm:ss").fromNow();
            });

            var ticketListado = $('.moment-tickets-listado');
            $(ticketListado).each(function (i, item) {
                $('.timeAgoTicketListado')[i].innerHTML = moment($(this).text(), "YYYY-MM-DD HH:mm:ss").fromNow();
            });

            $(document).on('click', '.delete-item', function () {
                var row = $(this).parents('tr');
                var name = row.find('td span.child-text-delete').text();
                console.log("name:::", name);
                var id = $(this).data('id');
                var url = $(this).data('href');
                console.log("url:::", url);
                var mensaje = $(this).data('mensaje');
                console.log("mensaje:::", mensaje);
                var csrf = $(this).data('csrf');
                console.log("csrf:::", csrf);

                swal({
                    title: "Atención...",
                    html: "¿Está seguro de eliminar " + mensaje + " <strong>" + name + "</strong> ?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonText: "SI, ELIMINARLO",
                    cancelButtonColor: '#d33',
                    cancelButtonText: "Cancelar"
                }).then(function () {
                    $.ajax({
                        url: url,
                        type: 'DELETE',
                        headers: {'X-CSRF-Token': csrf},
                        dataType: 'json',
                        beforeSend: function () {

                        },
                        success: function (response) {
                            swal({
                                title: "Resultado",
                                html: response.data.message,
                                type: "success"
                            }).then(function () {
                                window.location.href = response.data.route
                            }).catch(swal.noop);
                        },
                        error: function (err) {
                            swal("Respuesta", "NO pudo eliminarse.", "error");
                            console.log("show_error_err: ", err);
                            console.log("show_error_errResponseText: ", err.responseText);
                        }
                    });
                }).catch(swal.noop);
            });

            $(document).on('click', '#btnFiltroTickets', function () {
                var button = $('#btnFiltroTickets');
                var rangoFechas = $("#date_range_time").val();
                var rangoFechasSplit = rangoFechas.split(' - ');
                var firstDate = rangoFechasSplit[0];
                var secondDate = rangoFechasSplit[1];

                var data_ = {
                    'desde': firstDate,
                    'hasta': secondDate,
                    'estado_ticket_id': $("#estado_ticket").val(),
                    'codigo': $("#codigo").val()
                };

                console.log(data_);

                var url_ = $('.urlFiltroTickets').data('url');
                console.log("url_:::", url_);

                var inputToken = $("input[name=_token]").val();

                $.ajax({
                    url: url_,
                    type: 'POST',
                    headers: {'X-CSRF-Token': inputToken},
                    dataType: 'json',
                    data: data_,
                    beforeSend: function () {
                        button.attr('disabled', true);
                    },
                    success: function (response) {
                        console.log("response:::", response);
                        var content = "";
                        if (response.estado === 1) {
                            if (response.ticket) {
                                content = '<tr>' +
                                    '<td>' +
                                    '<span><i class="zmdi zmdi-account"></i> ' + response.ticket.persona.apellidos_nombres + '</span>' +
                                    '<span style="display: block;margin-bottom: .5rem;margin-top: .5rem;" class="child-text-delete">#' + response.ticket.codigo + '</span>' +
                                    '<small style="border-radius: 8px;" class="label label-' + response.ticket.estadoTicket.color + '">' + response.ticket.estadoTicket.message + '</small>' +
                                    '</td>' +
                                    '<td>' +
                                    '<span class="d-none moment-tickets-listado">' + response.ticket.estadoTicketFecha + '</span>' +
                                    '<i class="fa fa-clock-o"></i> ' + response.ticket.estadoTicketFechaFormat +
                                    '<br>' +
                                    '<small class="text-warning timeAgoTicketListado" style="font-weight: bold;font-size: 1em;">' + moment(response.ticket.estadoTicketFecha, "YYYY-MM-DD HH:mm:ss").fromNow() + '</small>' +
                                    '</td>' +
                                    '<td>' + response.ticket.tecnico + '</td>' +
                                    '<td class="text-navy td-a">' +
                                    '<a href="' + response.ticket.urlDetalle + '" class="btn btn-primary">' +
                                    '<i class="zmdi zmdi-eye"></i>' +
                                    '</a>';
                                if (response.ticket.urlEliminar !== null) {
                                    content += '<a ' +
                                        'href="javascript:;"' +
                                        'data-csrf="' + inputToken + '"' +
                                        'data-id="' + response.ticket.id + '"' +
                                        'data-mensaje="el ticket"' +
                                        'data-href="' + response.ticket.urlEliminar + '"' +
                                        'class="btn btn-danger delete-item">' +
                                        '<i class="zmdi zmdi-close"></i>' +
                                        '</a>';
                                }
                                content += '</td>' +
                                    '</tr>';
                                $("#bodyTickets").html(content);
                                toastNotify(response.message, 'success');
                            } else {
                                console.log("contenido tickets:::", response.tickets);
                                // var content = "";
                                if (response.tickets.length > 0) {

                                    $.each(response.tickets, function (key, value) {
                                        content += '<tr>' +
                                            '<td>' +
                                            '<span><i class="zmdi zmdi-account"></i> ' + value.persona.apellidos_nombres + '</span>' +
                                            '<span style="display: block;margin-bottom: .5rem;margin-top: .5rem;" class="child-text-delete">#' + value.ticket.codigo + '</span>' +
                                            '<small style="border-radius: 8px;" class="label label-' + value.estadoTicket.color + '">' + value.estadoTicket.message + '</small>' +
                                            '</td>' +
                                            '<td>' +
                                            '<span class="d-none moment-tickets-listado">' + value.estadoTicketFecha + '</span>' +
                                            '<i class="fa fa-clock-o"></i> ' + value.estadoTicketFechaFormat +
                                            '<br>' +
                                            '<small class="text-warning timeAgoTicketListado" style="font-weight: bold;font-size: 1em;">' + moment(value.estadoTicketFecha, "YYYY-MM-DD HH:mm:ss").fromNow() + '</small>' +
                                            '</td>' +
                                            '<td>' + value.tecnico + '</td>' +
                                            '<td class="text-navy td-a">' +
                                            '<a href="' + value.urlDetalle + '" class="btn btn-primary">' +
                                            '<i class="zmdi zmdi-eye"></i>' +
                                            '</a>';
                                        if (value.urlEliminar !== null) {
                                            content += '<a ' +
                                                'href="javascript:;"' +
                                                'data-csrf="' + inputToken + '"' +
                                                'data-id="' + value.id + '"' +
                                                'data-mensaje="el ticket"' +
                                                'data-href="' + value.urlEliminar + '"' +
                                                'class="btn btn-danger delete-item">' +
                                                '<i class="zmdi zmdi-close"></i>' +
                                                '</a>';
                                        }
                                        content += '</td>' +
                                            '</tr>';
                                    });
                                    $("#bodyTickets").html(content);
                                    toastNotify(response.message, 'success');
                                }
                            }
                        } else {
                            content += '<tr>' +
                                '<td colspan="4" class="text-center">No hay coincidencias</td>' +
                                '</tr>';
                            $("#bodyTickets").html(content);
                            toastNotify(response.message, 'error');
                        }
                    },
                    error: function (err) {
                        console.log("err:::", err.responseJSON);
                    },
                    complete: function () {
                        button.attr('disabled', false);
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('soporte.layouts.template', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>