<?php if(Session::has('message')): ?>
    <div class="alert <?php echo e(Session::get('alert-class', 'alert-info')); ?> alert-dismissible alert-fixed" role="alert">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span
                    aria-hidden="true">&times;</span></button>
        <?php echo e(Session::get('message')); ?>

    </div>
<?php endif; ?>

<?php if(Session::has('notify')): ?>
    <?php
    $message = Session::get('notify.message');
    $alert = Session::get('notify.alert');
    $icon = (Session::get('notify.icon') != null) ? Session::get('notify.icon') : 'fa-check';
    $position = (Session::get('notify.position') != null) ? Session::get('notify.position') : 'top-right';
    $delay = (Session::get('notify.delay') != null) ? Session::get('notify.delay') : '5000';
    ?>
    <script>
        $(function () {
            Notify("<?php echo e($message); ?>", '<?php echo e($position); ?>', '<?php echo e($delay); ?>', '<?php echo e($alert); ?>', '<?php echo e($icon); ?>', true);
        });
    </script>
<?php endif; ?>