<?php $__env->startSection('title', 'Módulo de Personas'); ?>
<?php $__env->startSection('content'); ?>
<?php $user = Auth::guard('superadmin')->user(); ?>
<?php echo $__env->make('superadmin.layouts.partials.breadcrumbs', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<div class="page-header position-relative">
    <div class="header-title">
        <h1>Módulo de Personas</h1>
    </div>
    <div class="header-buttons">
        <a class="icono-info" href="<?php echo e(route('superadmin.personas.create')); ?>">
            <i class="zmdi zmdi-plus-circle"></i>
        </a>
        <?php echo $__env->make('superadmin.layouts.partials.headerbuttons', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <a class="icono-success exportar_tabla_reporte" href="javascript:;">
            <i class="fa fa-file-excel-o"></i>
        </a>
    </div>
</div>
<div class="page-body">
    <div class="row">
        <div class="col-md-12 col-sm-12">
            <?php echo Form::open(['route'=>'api.v1.herramientas.clonartabla','class'=>'d-none','id'=>'form_exportar_tabla']); ?>

            <?php echo Form::hidden('tablaclonada', null, ['id' => 'tablaclonada']); ?>

            <?php echo Form::hidden('archivo', 'personas', ['class' => '']); ?>

            <?php echo Form::close(); ?>

        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="widget">
                <div class="widget-header ">
                    <span class="widget-caption">Listado de Personas</span>
                    <div class="widget-buttons">
                        <?php echo $__env->make('superadmin.layouts.partials.widgetbutton', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                    </div>
                </div>
                <div class="widget-body">
                    <div class="table-responsive row-none" id="resultado_filtro">
                        <table id="tablaListado" class="table table-striped table-bordered table-hover">
                            <thead class="headTablaListado">
                                <tr class="text-uppercase text-center th-head-inputs">
                                    <th>N°</th>
                                    <th>Apellidos y Nombres</th>
                                    <th>Sede</th>
                                    <th>Area</th>
                                    <th>Cargo</th>
                                    <th>D.N.I</th>
                                    <th>Email</th>
                                    <th>Anexo</th>
                                    <th>Teléfonos</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tfoot class="footTablaListado">
                                <tr class="text-uppercase">
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                            </tfoot>
                            <tbody>
                                <?php $n = 1 ?>
                                <?php foreach($personas as $persona): ?>
                                <tr>
                                    <td class="text-center"><?php echo e($n++); ?></td>
                                    <td class="child-text-delete"><?php echo e($persona->apellidos_nombres); ?></td>
                                    <td class="text-left"><?php echo e($persona->area->sede->nombre); ?></td>
                                    <td class="text-left"><?php echo e($persona->area->nombre); ?></td>
                                    <td class="text-left"><?php echo e($persona->cargo->nombre); ?></td>
                                    <td class="text-center"><?php echo e($persona->dni); ?></td>
                                    <td class="text-left"><?php echo e($persona->email); ?></td>
                                    <td class="text-center"><?php echo e($persona->anexo); ?></td>
                                    <td class="text-center"><?php echo mostrarTelefonos($persona->telefono_empresa,$persona->telefono_personal); ?></td>
                                    <td class="text-center">
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-primary dropdown-toggle"
                                                    data-toggle="dropdown">
                                                Acciones
                                                <span class="caret"></span>
                                            </button>
                                            <ul class="dropdown-menu pull-right" role="menu">
                                                <li>
                                                    <a href="<?php echo e(route('superadmin.personas.show', $persona->slug)); ?>"
                                                       class="">
                                                        <i class="zmdi zmdi-eye"></i>
                                                        Detalle
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="<?php echo e(route('superadmin.personas.edit',$persona->slug)); ?>"
                                                       class="">
                                                        <i class="zmdi zmdi-edit"></i>
                                                        Editar
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="javascript:;"
                                                       data-csrf="<?php echo e(csrf_token()); ?>"
                                                       data-id="<?php echo e($persona->id); ?>"
                                                       data-href="<?php echo e(route('superadmin.personas.welcome',$persona->id)); ?>"
                                                       class="welcome-item">
                                                        <i class="zmdi zmdi-email"></i>
                                                        Saludo de Bienvenida
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="<?php echo e(route('superadmin.cumpleanios.personal.tarjetapermiso',$persona->slug)); ?>"
                                                       target="_blank">
                                                        <i class="zmdi zmdi-cake"></i>
                                                        Generar tarjeta de permiso
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="javascript:;"
                                                       data-csrf="<?php echo e(csrf_token()); ?>"
                                                       data-id="<?php echo e($solicitud->id); ?>"
                                                       data-mensaje="la solicitud"
                                                       data-href="<?php echo e(route('superadmin.personas.delete',$persona->id)); ?>"
                                                       class="delete-item">
                                                        <i class="zmdi zmdi-close"></i>
                                                        Eliminar
                                                    </a>
                                                </li>
                                                <?php if($user->soporte==1): ?>
                                                <li class="divider"></li>
                                                <li>
                                                    <a href="<?php echo e(route('superadmin.personas.firmacorreo',$persona->id)); ?>"
                                                       data-toggle="modal"
                                                       data-target="#openModal"
                                                       data-tamanio="lg">
                                                        <i class="zmdi zmdi-email"></i>
                                                        Firma Correo
                                                    </a>
                                                </li>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
    $(function () {
        tablaListadoDataTable();
        $(".exportar_tabla_reporte").on('click', function () {
            var cant_registro = $('#tablaListado_length select');
            cant_registro.val(-1);
            cant_registro.trigger('change');
            var tabla_limpia = $("#tablaListado").clone();
            tabla_limpia.find('thead tr th:last-child').remove();
            tabla_limpia.find('tbody tr td:last-child').remove();
            tabla_limpia.find('tfoot').remove();
            tabla_limpia.find('thead tr th').css({
                'border': '0.5px solid #E0E0E0',
                'color': '#fff',
                'font-size': '16px',
                'background': '#00796B',
                'width': '100%',
                'height': 'auto'
            });
            tabla_limpia.find('tbody tr td').css({
                "mso-number-format": "'\@'",
                'border': '1px solid #E0E0E0',
                'background': 'transparent',
                'width': '100%',
                'height': 'auto'
            });
            //tabla_limpia.find('tbody tr td').css('border','1px solid #3498db');
            //tabla_limpia.find('tbody tr td').css("mso-number-format", "'\@'");
            $("#tablaclonada").val($("<div>").append(tabla_limpia).html());
            $("#form_exportar_tabla").submit();
            cant_registro.val(10);
            cant_registro.trigger('change');
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('superadmin.layouts.template', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>