<?php
$userRole = Auth::guard('admin')->user()->role_id;
?>

<?php $__env->startSection('title', 'Inicio'); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <?php /*<div class="home-option">*/ ?>
        <?php /*<div class="col-xs-12 col-sm-6 col-md-4">*/ ?>
        <?php /*<div class="card">*/ ?>
        <?php /*<a href="<?php echo e(route('admin.sede.index')); ?>">*/ ?>
        <?php /*<div class="card-header bgm-deeppurple m-b-20">*/ ?>
        <?php /*<h2>SEDE</h2>*/ ?>
        <?php /*<button class="btn mdc-bg-deep-purple-800 btn-float">*/ ?>
        <?php /*<i class="zmdi zmdi-pin animated infinite pulse"></i>*/ ?>
        <?php /*</button>*/ ?>
        <?php /*</div>*/ ?>

        <?php /*<div class="card-body card-padding ">*/ ?>
        <?php /*<p>Muestra las sedes, podrá seleccionar una sede y apareceran las personas que están*/ ?>
        <?php /*asociadas.</p>*/ ?>
        <?php /*</div>*/ ?>
        <?php /*</a>*/ ?>
        <?php /*</div>*/ ?>
        <?php /*</div>*/ ?>

        <?php /*<div class="col-xs-12 col-sm-6 col-md-4">*/ ?>
        <?php /*<div class="card">*/ ?>
        <?php /*<a href="<?php echo e(route('admin.area.index')); ?>">*/ ?>
        <?php /*<div class="card-header bgm-indigo m-b-20">*/ ?>
        <?php /*<h2>AREA</h2>*/ ?>
        <?php /*<button class="btn mdc-bg-indigo-800 btn-float">*/ ?>
        <?php /*<i class="zmdi zmdi-layers animated infinite pulse"></i>*/ ?>
        <?php /*</button>*/ ?>
        <?php /*</div>*/ ?>

        <?php /*<div class="card-body card-padding">*/ ?>
        <?php /*<p>Muestra las áreas donde usted pertenece, seleccione una y*/ ?>
        <?php /*mostrará las personas que pertenecen.</p>*/ ?>
        <?php /*</div>*/ ?>
        <?php /*</a>*/ ?>
        <?php /*</div>*/ ?>
        <?php /*</div>*/ ?>

        <div class="col-xs-12 col-sm-6 col-md-4 d-none">
            <div class="card">
                <a href="<?php echo e(route('admin.noticias.index')); ?>">
                    <div class="card-header mdc-bg-indigo m-b-20">
                        <h2 class="mdc-text-white-darker">NOTICIAS</h2>
                        <button class="btn mdc-bg-indigo-800 btn-float">
                            <i class="zmdi zmdi-notifications animated infinite pulse"></i>
                        </button>
                    </div>
                    <div class="card-body card-padding" style="padding-top:23px">
                        <p>Enterate de las ultimas noticias que Cable Perú tiene para ti.</p>
                    </div>
                </a>
            </div>
        </div>

        <div class="col-xs-12 col-sm-6 col-md-4">
            <div class="card">
                <a href="<?php echo e(route('admin.tickets.index')); ?>">
                    <div class="card-header bgm-bluegray m-b-20">
                        <h2>TICKETS</h2>
                        <button class="btn mdc-bg-blue-grey-800 btn-float">
                            <i class="zmdi zmdi-ticket-star animated infinite pulse"></i>
                        </button>
                    </div>
                    <div class="card-body card-padding">
                        <p>Podrás generar un ticket de atención y ver el estado de atención del ticket que previamente
                            generaste.</p>
                    </div>
                </a>
            </div>
        </div>

        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="card">
                    <div class="card-header bgm-blue m-b-20">
                        <h2>FAQ's</h2>
                        <button class="btn mdc-bg-blue-grey-800 btn-float">
                            <i class="zmdi zmdi-help animated infinite pulse"></i>
                        </button>
                    </div>
                    <div class="card-body card-padding">
                        <div id="accordion">
                            <div class="card active">
                                <div class="card-header mdc-bg-grey text-white" id="headingOne">
                                    <h5 class="mb-0">
                                        <button class="btn-link text-white" style="color: #FFF!important; font-size: 1.3em" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                            Modificar Contraseña Correo Electrónico (Office 365)
                                        </button>
                                    </h5>
                                </div>

                                <div id="collapseOne" class="collapse" aria-labelledby="headingOne" data-parent="#accordion">
                                    <div class="card-body card-padding">
                                        <ol>
                                            <li>Ingresar a su cuenta de correo mediante Outlook Web: https://outlook.office.com/mail/</li>
                                            <li>Ir a la opción Administrador de Cuenta, ubicado al lado superior derecho de la página (este acceso aparece con las iniciales del usuario).</li>
                                            <li>Seleccionar la opción “Ver Cuenta”.<br /><br /><img src="/public/assets/img/faq1.png" /></li>
                                            <li>Seleccionar la opción “Contraseña”, ubicado en el menú vertical al lado izquierdo de la página.</li>
                                            <li>Colocar su contraseña anterior, la nueva contraseña y Enviar.<br /><br /><img src="/public/assets/img/faq2.png" /></li>
                                        </ol>
                                    </div>
                                </div>
                            </div>

                            <div class="card active"> 
                                <div class="card-header mdc-bg-grey text-white" id="headingTwo">
                                    <h5 class="mb-0">
                                        <button class="btn-link text-white" style="color: #FFF!important; font-size: 1.3em" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="true" aria-controls="collapseTwo">
                                            Restablecer Contraseña Correo Electrónico (Office 365)
                                        </button>
                                    </h5>
                                </div>

                                <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordion">
                                    <div class="card-body card-padding">
                                        <ol>
                                            <li>Ingresar a su cuenta de correo mediante Outlook Web: https://outlook.office.com/mail/</li>
                                            <li>Ir a la opción “¿No puede acceder a su cuenta?, en esta sección deberá actualizar sus datos para que Office 365 pueda enviar códigos de verificación.</li>
                                            <li>Seleccione “Cuenta profesional o educativa”, en caso se la pidan.</li>
                                            <li>Ingrese su dirección de correo electrónico.</li>
                                            <li>Seleccione la opción “Enviar mensaje de texto a mi teléfono móvil”.</li>
                                            <li>Ingrese su número de teléfono móvil y presione el botón “Texto”.</li>
                                            <li>Recibirá un código de verificación en su teléfono móvil, el cual deberá ingresar y presionar el botón “Siguiente”.</li>
                                            <li>Ingrese la nueva contraseña, confírmela y presione el botón “Finalizar”.</li>
                                        </ol>
                                        <p><span style="font-weight: bold">Nota:</span> Es posible que necesite descargar e instalar el software “Authenticator” en su celular como paso previo para validar su sesión en Office 365. De ser así, hacerlo al inicio de todos los pasos indicados.</p>
                                    </div>
                                </div>
                            </div>

                            <div class="card active">
                                <div class="card-header mdc-bg-grey text-white" id="headingThree">
                                    <h5 class="mb-0">
                                        <button class="btn-link text-white" style="color: #FFF!important; font-size: 1.3em" data-toggle="collapse" data-target="#collapseThree" aria-expanded="true" aria-controls="collapseThree">
                                            Modificar Contraseña ERP
                                        </button>
                                    </h5>
                                </div>

                                <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordion">
                                    <div class="card-body card-padding">
                                        <ol>
                                            <li>Iniciar sesión en el ERP con sus credenciales actuales.</li>
                                            <li>Ir al menú Sistema / Cambiar Contraseña de Usuario.</li>
                                            <li>Colocar la contraseña anterior, la nueva contraseña y Aceptar.</li>
                                        </ol>
                                    </div>
                                </div>
                            </div>

                            <div class="card active">
                                <div class="card-header mdc-bg-grey text-white" id="headingFour">
                                    <h5 class="mb-0">
                                        <button class="btn-link text-white" style="color: #FFF!important; font-size: 1.3em" data-toggle="collapse" data-target="#collapseFour" aria-expanded="true" aria-controls="collapseFour">
                                            Restablecer/Modificar Contraseña INVISTA
                                        </button>
                                    </h5>
                                </div>

                                <div id="collapseFour" class="collapse" aria-labelledby="headingFour" data-parent="#accordion">
                                    <div class="card-body card-padding">
                                        <ol>
                                            <li>Ir a la dirección web de INVISTA que le corresponda.</li>
                                            <li>Buscar la opción “Restablece tu contraseña” en la parte inferior del inicio de sesión.</li>
                                            <li>Ingresar el nombre de usuario y presionar el botón “Restablecer contraseña”</li>
                                            <li>Se enviará un correo electrónico con una “contraseña temporal” para que pueda iniciar sesión (en caso de no recibir ningún correo, deberá confirmar con el administrador del sistema la configuración correcta de su usuario, también puede buscar el correo en la sección SPAM)</li>
                                            <li>Una vez iniciada la sesión, podrá actualizar su contraseña de acceso.</li>
                                        </ol>
                                    </div>
                                </div>
                            </div>

                            <div class="card active">
                                <div class="card-header mdc-bg-grey text-white" id="headingFive">
                                    <h5 class="mb-0">
                                        <button class="btn-link text-white" style="color: #FFF!important; font-size: 1.3em" data-toggle="collapse" data-target="#collapseFive" aria-expanded="true" aria-controls="collapseFive">
                                            Visualizar/Descargar Manuales de Usuario
                                        </button>
                                    </h5>
                                </div>

                                <div id="collapseFive" class="collapse" aria-labelledby="headingFive" data-parent="#accordion">
                                    <div class="card-body card-padding">
                                        <ol>
                                            <li>Ingresar a la dirección web de INVISTA Ticketera.</li>
                                            <li>Buscar el manual que necesite visualizar e ingresar dando click sobre el nombre. Los manuales están separados en ERP e INVISTA.</li>
                                        </ol>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
            </div>
        </div>

        <!--INICIO DE CAMBIOS-->
        <div class="col-lg-9 d-none">
            <div class="ibox ">
                <div class="ibox-title">
                    <h5>Tickets</h5>
                    <?php echo $__env->make('soporte.layouts.partials.widgetbutton', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                </div>
                <div class="ibox-content">
                    <?php echo Form::open(['url'=>'#', 'class'=>'row soporteTickets', 'autocomplete'=>'off']); ?>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <?php echo Form::label('date_range_time', 'Rango Fechas', ['class' => '']); ?>

                            <?php echo Form::text('date_range_time',($firstDay.' - '.$lastDay),['class'=>'form-control form-control-sm','id'=>'date_range_time','placeholder'=>'Rango de Fechas']); ?>

                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <?php echo Form::label('estado_ticket', 'Estado', ['class' => '']); ?>

                            <?php echo Form::select('estado_ticket', $estadoTickets, null, ['id'=>'estado_ticket', 'class'=>'select2 form-control-sm','placeholder'=>'Seleccione Estado']); ?>

                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <?php echo Form::label('codigo', '# Ticket', ['class' => '']); ?>

                            <?php echo Form::text('codigo',null,['class'=>'form-control form-control-sm','id'=>'codigo','placeholder'=>'# Ticket']); ?>

                        </div>
                    </div>
                    <div class="col-sm-2">
                        <button type="button" class="btn btn-sm btn-primary" id="btnFiltroTickets">
                            <i class="zmdi zmdi-filter-list"></i> Filtrar
                        </button>
                    </div>
                    <?php echo e(Form::close()); ?>


                    <div class="table-responsive" id="resultado_filtro">
                        <table id="tablaListado" class="table table-hover no-margins">
                            <thead>
                            <tr class="text-uppercase">
                                <th>#Ticket</th>
                                <th>Asunto</th>
                                <th>Fecha</th>
                                <th>Personal</th>
                                <th>Acciones</th>
                            </tr>
                            </thead>
                            <tbody id="bodyTickets">
                            <?php $__empty_1 = true; foreach($ticketEstados as $ticketEstado): $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <span>
                                            <i class="zmdi zmdi-account"></i>
                                            <?php echo e($ticketEstado->persona->apellidos_nombres); ?>

                                        </span>

                                        <span style="display: block;margin-bottom: .5rem;margin-top: .5rem;"
                                              class="child-text-delete">#<?php echo e($ticketEstado->ticket->codigo); ?></span>
                                        <small style="border-radius: 8px;"
                                               class="label label-<?php echo e($ticketEstado->estadoTicket['color']); ?>"><?php echo e($ticketEstado->estadoTicket['message']); ?></small>
                                    </td>
                                    <td>
                                            <?php echo e($ticketEstado->ticket->asunto); ?>


                                       </td>
                                    <td>
                                        <span class="d-none moment-tickets-listado"><?php echo e($ticketEstado->estadoTicketFecha); ?></span>
                                        <i class="fa fa-clock-o"></i> <?php echo e(fechaEstadoTicket($ticketEstado->estadoTicketFecha)); ?>

                                        <br>
                                        <small class="text-warning timeAgoTicketListado"
                                               style="font-weight: bold;font-size: 1em;"></small>
                                    </td>
                                    <td><?php echo tecnicoTicket($ticketEstado->tecnico); ?></td>
                                    <td class="text-navy td-a">
                                        <a href="<?php echo e(route('soporte.tickets.detalle', $ticketEstado->ticket->codigo)); ?>"
                                           class="btn btn-primary">
                                            <i class="zmdi zmdi-eye"></i>
                                        </a>
                                        <?php if($ticketEstado->estadoTicket['message'] != "Atendido"): ?>
                                            <a href="javascript:;"
                                               data-csrf="<?php echo e(csrf_token()); ?>"
                                               data-id="<?php echo e($ticketEstado->ticket_id); ?>"
                                               data-mensaje="el ticket"
                                               data-href="<?php echo e(route('soporte.tickets.delete',$ticketEstado->ticket_id)); ?>"
                                               class="delete-item btn btn-danger">
                                                <i class="zmdi zmdi-close"></i>
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4">No hay coincidencias</td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <span class="urlFiltroTickets" data-url="<?php echo e(route('soporte.ajax.filtro.tickets')); ?>"></span>
        <!--FIN DE CAMBIOS-->

        <div class="col-xs-12 col-sm-6 col-md-4 d-none">
            <div class="card">
                <a href="<?php echo e(route('admin.persona.index')); ?>">
                    <div class="card-header bgm-teal m-b-20">
                        <h2>PERSONA</h2>
                        <button class="btn mdc-bg-teal-800 btn-float">
                            <i class="zmdi zmdi-account-calendar animated infinite pulse"></i>
                        </button>
                    </div>

                    <div class="card-body card-padding">
                        <p>Ingrese parte del nombre de la persona se visualizara la información, podrá guardarlo
                            como favorito.</p>
                    </div>
                </a>
            </div>
        </div>

        <div class="col-xs-12 col-sm-6 col-md-4 d-none">
            <div class="card">
                <a href="<?php echo e(route('admin.recursoshumanos.index')); ?>">
                    <div class="card-header bgm-pink m-b-20">
                        <h2>RECURSOS HUMANOS</h2>
                        <button class="btn mdc-bg-pink-800 btn-float">
                            <i class="zmdi zmdi-badge-check animated infinite pulse"></i>
                        </button>
                    </div>

                    <div class="card-body card-padding">
                        <p>Encontrará archivos para que descargue, memorandum, papeletas de salidas, Horas extras.</p>
                    </div>
                </a>
            </div>
        </div>

        <div class="col-xs-12 col-sm-6 col-md-4 d-none">
            <div class="card">
                <a href="<?php echo e(route('admin.favoritos.index')); ?>">
                    <div class="card-header bgm-red m-b-20">
                        <h2>FAVORITOS</h2>
                        <button class="btn mdc-bg-red-800 btn-float">
                            <i class="zmdi zmdi-favorite animated infinite pulse"></i>
                        </button>
                    </div>

                    <div class="card-body card-padding">
                        <p>Muestra un listado de personas favoritas agregados por usted para el acceso rápido a
                            observar.</p>
                    </div>
                </a>
            </div>
        </div>

        <div class="col-xs-12 col-sm-6 col-md-4 d-none">
            <div class="card">
                <a href="<?php echo e(route('admin.cumpleanios.index')); ?>">
                    <div class="card-header bgm-amber m-b-20">
                        <h2>CUMPLEAÑOS</h2>
                        <button class="btn mdc-bg-amber-800 btn-float">
                            <i class="zmdi zmdi-cake animated infinite pulse"></i>
                        </button>
                    </div>

                    <div class="card-body card-padding">
                        <p>Muestra un listado del personal que cumplen años en este mes de
                            <strong>"<?php echo e(ucfirst(monthActual())); ?>"</strong>.</p>
                    </div>
                </a>
            </div>
        </div>

        <div class="col-xs-12 col-sm-6 col-md-4 d-none">
            <div class="card">
                <a href="<?php echo e(route('admin.perfil.index')); ?>">
                    <div class="card-header bgm-blue m-b-20">
                        <h2>PERFÍL</h2>
                        <button class="btn mdc-bg-blue-800 btn-float">
                            <i class="zmdi zmdi-account animated infinite pulse"></i>
                        </button>
                    </div>

                    <div class="card-body card-padding">
                        <p>Muestra tú información personal, podrás editarla.</p>
                    </div>
                </a>
            </div>
        </div>
    </div>
    <?php /*</div>*/ ?>
    <style>
        .card-body p {
            margin-bottom: 0;
            color: #000;
        }
        ol li{
            padding: 1em;
        }
        @media  screen and (min-width: 768px) {
            .card .card-header:not(.ch-alt) {
                padding: 10px 15px!important;
            }
        }
        .card .card-header h5{
            margin: 0!important;
        }
        .card{
            margin-bottom: 10px;
        }

    </style>
<?php $__env->stopSection(); ?>

<!--INICIO DE CAMBIOS-->
<?php $__env->startSection('scripts'); ?>
    <script>
        $(function () {
            moment.locale('es');
            $(".select2").select2({
                placeholder: "Seleccione Estado",
                // allowClear: true
            });

            $('#date_range_time').daterangepicker({
                format: 'DD-MM-YYYY',
                locale: {
                    applyLabel: "Aplicar",
                    cancelLabel: "Cancelar",
                    fromLabel: "Desde",
                    toLabel: "Hasta",
                    customRangeLabel: "Custom",
                    daysOfWeek: [
                        'Dom',
                        'Lun',
                        'Mar',
                        'Mie',
                        'Jue',
                        'Vie',
                        'Sáb'
                    ],
                    monthNames: [
                        'Enero',
                        'Febrero',
                        'Marzo',
                        'Abril',
                        'Mayo',
                        'Junio',
                        'Julio',
                        'Agosto',
                        'Setiembre',
                        'Outubre',
                        'Noviembre',
                        'Diciembre'
                    ],
                    firstDay: 1
                },
                opens: 'left',
                drops: 'down',
                buttonClasses: 'btn btn-sm',
                applyClass: 'btn-success',
                cancelClass: 'btn-default'
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<!--FIN DE CAMBIOS-->

<?php echo $__env->make('admin.layouts.template', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>