<?php $__env->startSection('title', 'Compañeros'); ?>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.layouts.partials.breadcrumbs', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <div class="card" id="profile-main">
        <?php echo $__env->make('admin.personas.partials.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        <div class="pm-body clearfix">

            <ul class="tab-nav tn-justified">
                <li class="waves-effect">
                    <a href="<?php echo e(route('admin.persona.detalle',$slug)); ?>">Información</a>
                </li>
                <li class="active waves-effect">
                    <a href="<?php echo e(route('admin.persona.detalle.companieros',$slug)); ?>">Compañeros</a>
                </li>
            </ul>

            <div class="pmb-block">
                <?php if(count($personas) > 0): ?>
                    <div class="p-header">
                        <ul class="p-menu">
                            <li class="pm-search" style="display: block;">
                                <div class="pms-inner">
                                    <i class="zmdi zmdi-search"></i>
                                    <input type="text" id="searchPersona" placeholder="Filtra nombre...">
                                </div>
                            </li>
                        </ul>
                    </div>

                    <div class="contacts c-profile clearfix row" style="padding-top: 20px;">
                        <?php foreach($personas as $persona): ?>
                            <?php $errorImage = asset('img/profile/' . (($persona->genero == 'M') ? "man" : "women") . ".png"); ?>
                            <div class="col-md-3 col-sm-4 col-xs-6 listadoPersona ">
                                <a href="<?php echo e(route('admin.persona.detalle',$persona->slug)); ?>" class="ci-avatar"
                                   style="display: block;">
                                    <div class="c-item">
                                        <div class="ci-avatar show-photo-profile-radius">
                                            <?php echo e(Html::image(loadPhotoProfile($persona->foto,$persona->genero), $persona->apellidos_nombres,['class'=>'p-10 b-radius-50','onerror'=>"this.src='".$errorImage."'"])); ?>

                                        </div>
                                        <div class="c-info">
                                            <strong><?php echo e($persona->apellidos_nombres); ?></strong>
                                            <small><?php echo e(existsContent($persona->email)); ?></small>
                                        </div>
                                        <div class="c-footer">
                                            <button class="waves-effect"><i class="zmdi zmdi-eye"></i></button>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <p>Personal no cuenta con compañeros.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <style>
        .p-menu .pms-inner input[type="text"]:focus {
            width: 100%;
        }

        @media (min-width: 768px) {
            .p-menu .pms-inner input[type="text"] {
                width: 100%;
            }
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.template', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>