<?php $__env->startSection('title', 'Sub-Listas de '.ucwords(mb_strtolower($lista->nombre, 'UTF-8'))); ?>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('superadmin.layouts.partials.breadcrumbs', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>Sub-Listas de <?php echo e(ucwords(mb_strtolower($lista->nombre, 'UTF-8'))); ?></h1>
        </div>
        <div class="header-buttons">
            <a class="add-register" href="<?php echo e(route('superadmin.herramientas.listas.sublista.crear',$lista->slug)); ?>"
               data-toggle="modal"
               data-target="#openModal"
               data-tamanio="sm">
                <i class="zmdi zmdi-plus-circle"></i>
            </a>
            <?php echo $__env->make('superadmin.layouts.partials.headerbuttons', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        </div>
    </div>
    <div class="page-body">
        <div class="row">
            <div class="col-md-12">

                <div class="widget">
                    <div class="widget-header ">
                        <span class="widget-caption">
                            Listado <?php echo e(ucwords(mb_strtolower($lista->nombre, 'UTF-8'))); ?> Sub-Lista</span>
                        <div class="widget-buttons">
                            <?php echo $__env->make('superadmin.layouts.partials.widgetbutton', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                        </div>
                    </div>
                    <div class="widget-body">
                        <div class="table-responsive row-none" id="resultado_filtro">
                            <table id="tablaListado" class="table table-striped table-bordered table-hover">
                                <thead class="headTablaListado">
                                <tr class="text-uppercase text-center th-head-inputs">
                                    <th>N°</th>
                                    <th>nombre</th>
                                    <th>Descripción</th>
                                    <th>Sub-Listas</th>
                                    <th>ACCIONES</th>
                                </tr>
                                </thead>
                                <tfoot class="footTablaListado">
                                <tr class="text-uppercase">
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php $n = 1?>
                                <?php foreach($subListas as $subLista): ?>
                                    <tr>
                                        <td class="text-center"><?php echo e($n++); ?></td>
                                        <td class=""><?php echo e($subLista->nombre); ?></td>
                                        <td class=""><?php echo e($subLista->descripcion); ?></td>
                                        <td class="text-center">
                                            <a href="<?php echo e(route('superadmin.herramientas.listas.sublista.sub.index',[$lista->slug, $subLista->slug])); ?>"
                                               class="btn btn-purple shiny btn-circle btn-xs">
                                                <?php echo e($subLista->sub_listas_count); ?>

                                            </a>
                                        </td>
                                        <td class="text-center">
                                            <div class="btn-group">
                                                <a class="btn btn-primary dropdown-toggle btn-sm"
                                                   data-toggle="dropdown">
                                                    Acciones <i class="fa fa-angle-down"></i>
                                                </a>
                                                <ul class="dropdown-menu pull-right">
                                                    <?php /*<li>*/ ?>
                                                        <?php /*<a href="<?php echo e(route('superadmin.herramientas.listas.sublista.detalle', [$lista->slug, $subLista->slug])); ?>"*/ ?>
                                                           <?php /*class=""*/ ?>
                                                           <?php /*data-toggle='modal'*/ ?>
                                                           <?php /*data-target="#openModal"*/ ?>
                                                           <?php /*data-tamanio='sm'>*/ ?>
                                                            <?php /*<i class="zmdi zmdi-eye"></i>*/ ?>
                                                            <?php /*Detalle*/ ?>
                                                        <?php /*</a>*/ ?>
                                                    <?php /*</li>*/ ?>
                                                    <li>
                                                        <a href="<?php echo e(route('superadmin.herramientas.listas.sublista.editar', [$lista->slug, $subLista->slug])); ?>"
                                                           class=""
                                                           data-toggle='modal'
                                                           data-target="#openModal"
                                                           data-tamanio='sm'>
                                                            <i class="zmdi zmdi-edit"></i>
                                                            Editar
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(function () {
            tablaListadoDataTable();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('superadmin.layouts.template', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>