<?php $__env->startSection('title', 'Módulo de Sedes'); ?>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('superadmin.layouts.partials.breadcrumbs', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>Módulo de Sedes</h1>
        </div>
        <div class="header-buttons">
            <a class="" href="<?php echo e(route('superadmin.sedes.create')); ?>">
                <i class="zmdi zmdi-plus-circle"></i>
            </a>
            <?php echo $__env->make('superadmin.layouts.partials.headerbuttons', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        </div>
    </div>
    <div class="page-body">
        <div class="row">
            <div class="col-md-12">

                <div class="widget">
                    <div class="widget-header ">
                        <span class="widget-caption">Listado de Sedes</span>
                        <div class="widget-buttons">
                            <?php echo $__env->make('superadmin.layouts.partials.widgetbutton', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                        </div>
                    </div>
                    <div class="widget-body">
                        <div class="table-responsive row-none" id="resultado_filtro">
                            <table id="tablaListado" class="table table-striped table-bordered table-hover">
                                <thead class="headTablaListado">
                                <tr class="text-uppercase text-center th-head-inputs">
                                    <th>N°</th>
                                    <th>Nombre</th>
                                    <th>Dirección</th>
                                    <th>Latitud - Longitud</th>
                                    <th>areas</th>
                                    <th>Acciones</th>
                                </tr>
                                </thead>
                                <tfoot class="footTablaListado">
                                <tr class="text-uppercase">
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php $n = 1?>
                                <?php foreach($sedes as $sede): ?>
                                    <tr>
                                        <td class="text-center"><?php echo e($n++); ?></td>
                                        <td class="child-text-delete"><?php echo e($sede->nombre); ?></td>
                                        <td class="text-left"><?php echo e($sede->direccion); ?></td>
                                        <td class="text-center"><?php echo e($sede->latitud. " - ". $sede->longitud); ?></td>
                                        <td class="text-center">
                                            <a href="javascript:;"
                                               class="btn btn-purple shiny btn-circle btn-xs"
                                               data-toggle='modal'
                                               data-target="#openModal"
                                               data-tamanio='sm'>
                                                <?php echo e($sede->areas_count); ?>

                                            </a>
                                        </td>
                                        <td class="text-center">

                                            <div class="btn-group">
                                                <button type="button" class="btn btn-primary dropdown-toggle"
                                                        data-toggle="dropdown">
                                                    Acciones
                                                    <span class="caret"></span>
                                                </button>
                                                <ul class="dropdown-menu pull-right" role="menu">
                                                    <li>
                                                        <a href="<?php echo e(route('superadmin.sedes.show',$sede->slug)); ?>"
                                                           class="">
                                                            <i class="zmdi zmdi-eye"></i>
                                                            Detalle
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="<?php echo e(route('superadmin.sedes.edit',$sede->slug)); ?>"
                                                           class="">
                                                            <i class="zmdi zmdi-edit"></i>
                                                            Editar
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="javascript:;"
                                                           data-csrf="<?php echo e(csrf_token()); ?>"
                                                           data-id="<?php echo e($sede->id); ?>"
                                                           data-mensaje =" la sede "
                                                           data-href="<?php echo e(route('superadmin.sedes.delete',$sede->id)); ?>"
                                                           class="delete-item">
                                                            <i class="zmdi zmdi-close"></i>
                                                            Eliminar
                                                        </a>
                                                    </li>

                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(function () {
            tablaListadoDataTable();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('superadmin.layouts.template', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>