@extends('superadmin.layouts.template')
@section('title', 'Módulo de Usuarios')
@section('content')
    @include('superadmin.layouts.partials.breadcrumbs')
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>Módulo de Usuarios</h1>
        </div>
        <div class="header-buttons">
            {{--<a class="" href="{{ route('superadmin.usuarios.create') }}"--}}
               {{--data-toggle='modal'--}}
               {{--data-target="#openModal"--}}
               {{--data-tamanio='md'>--}}
                {{--<i class="zmdi zmdi-plus-circle"></i>--}}
            {{--</a>--}}
            @include('superadmin.layouts.partials.headerbuttons')
        </div>
    </div>
    <div class="page-body">
        <div class="row">
            <div class="col-md-12">
                <div class="widget">
                    <div class="widget-header ">
                        <span class="widget-caption">Listado de Usuarios</span>
                        <div class="widget-buttons">
                            @include('superadmin.layouts.partials.widgetbutton')
                        </div>
                    </div>
                    <div class="widget-body">
                        <div class="table-responsive row-none" id="resultado_filtro">
                            <table id="tablaListado" class="table table-striped table-bordered table-hover">
                                <thead class="headTablaListado">
                                <tr class="text-uppercase text-center th-head-inputs">
                                    <th>N°</th>
                                    <th>USUARIO</th>
                                    <th>APELLIDOS Y NOMBRES</th>
                                    <th>EMAIL</th>
                                    <th>ROL</th>
                                    <th>ACTIVO</th>
                                    <th>ACCIONES</th>
                                </tr>
                                </thead>
                                <tfoot class="footTablaListado">
                                <tr class="text-uppercase">
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php $n = 1?>
                                @foreach($users as $user)
                                    @if($user->role_id !=1)
                                        <tr>
                                            <td class="text-center">{{ $n++ }}</td>
                                            <td class="text-center">{{ $user->username }}</td>
                                            <td class="child-text-delete">{{ $user->last_first_name }}</td>
                                            <td class="text-left">{{ $user->email }}</td>
                                            <td class="text-center">{{ $user->role->description }}</td>
                                            <td class="text-center">
                                                {!! verifyActive($user->deleted_at)  !!}
                                            </td>
                                            <td class="text-center">

                                                <div class="btn-group">
                                                    <button type="button" class="btn btn-primary dropdown-toggle"
                                                            data-toggle="dropdown">
                                                        Acciones
                                                        <span class="caret"></span>
                                                    </button>
                                                    <ul class="dropdown-menu pull-right" role="menu">
                                                        <li>
                                                            <a href="{{ route('superadmin.usuarios.show',$user->id) }}"
                                                               class=""
                                                               data-toggle='modal'
                                                               data-target="#openModal"
                                                               data-tamanio='lg'>
                                                                <i class="zmdi zmdi-eye"></i>
                                                                Detalle
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="{{ route('superadmin.usuarios.password',$user->id) }}"
                                                               class=""
                                                               data-toggle="modal"
                                                               data-target="#openModal"
                                                               data-tamanio="sm">
                                                                <i class="zmdi zmdi-lock-outline"></i>
                                                                Cambiar Contraseña
                                                            </a>
                                                        </li>
                                                        @if($user->deleted_at == null)
                                                            <li>
                                                                <a href="{{ route('superadmin.usuarios.edit',$user->id) }}"
                                                                   class=""
                                                                   data-toggle="modal"
                                                                   data-target="#openModal"
                                                                   data-tamanio="lg">
                                                                    <i class="zmdi zmdi-edit"></i>
                                                                    Editar
                                                                </a>
                                                            </li>
                                                            <li>
                                                                <a href="javascript:;"
                                                                   data-csrf="{{ csrf_token() }}"
                                                                   data-id="{{ $user->id }}"
                                                                   data-mensaje="al usuario"
                                                                   data-href="{{ route('superadmin.usuarios.delete',$user->id) }}"
                                                                   class="delete-item">
                                                                    <i class="zmdi zmdi-close"></i>
                                                                    Eliminar
                                                                </a>
                                                            </li>
                                                        @else
                                                            <li>
                                                                <a href="javascript:;"
                                                                   data-csrf="{{ csrf_token() }}"
                                                                   data-id="{{ $user->id }}"
                                                                   data-mensaje="al usuario"
                                                                   data-href="{{ route('superadmin.usuarios.restore',$user->id) }}"
                                                                   class="restore-item">
                                                                    <i class="zmdi zmdi-restore-left"></i>
                                                                    Restaurar
                                                                </a>
                                                            </li>
                                                        @endif

                                                    </ul>
                                                </div>


                                            </td>
                                        </tr>
                                    @endif
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $(function () {
            tablaListadoDataTable();
        });
    </script>
@stop