@extends('superadmin.layouts.template')
@section('title', 'Módulo de Tickets')
@section('content')
    <?php $user = Auth::guard('superadmin')->user(); ?>
    @include('superadmin.layouts.partials.breadcrumbs')
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>Módulo de Tickets</h1>
        </div>
        <div class="header-buttons">
            {{--<a href="{{ route('superadmin.personas.create') }}">--}}
            {{--<i class="zmdi zmdi-plus-circle"></i>--}}
            {{--</a>--}}
            @include('superadmin.layouts.partials.headerbuttons')
        </div>
    </div>
    <div class="page-body">
        <div class="row">
            <div class="col-md-12">
                <div class="col-md-3 col-sm-6 col-xs-12">
                    <a href="{{ route('superadmin.tickets.pendientes.index') }}">
                        <div class="databox bg-white radius-bordered">
                            <div class="databox-left bg-themePendientes">
                                <div class="databox-piechart">
                                    <div data-toggle="easypiechart" class="easyPieChart" data-barcolor="#fff"
                                         data-linecap="butt"
                                         data-percent="{{ isset($reportEasyTickets['pendientes']) ? $reportEasyTickets['pendientes']['porcentaje'] : '0' }}"
                                         data-animate="500" data-linewidth="3"
                                         data-size="47" data-trackcolor="rgba(255,255,255,0.1)">
                                        <span class="white font-90">{{ isset($reportEasyTickets['pendientes']) ? $reportEasyTickets['pendientes']['porcentaje'] : '0' }}%</span>
                                    </div>
                                </div>
                            </div>
                            <div class="databox-right">
                                <span class="databox-number themePendientes">{{ isset($reportEasyTickets['pendientes']) ? $reportEasyTickets['pendientes']['cantidad'] : 0 }}</span>
                                <div class="databox-text darkgray">PENDIENTES</div>
                                <div class="databox-stat themePendientes radius-bordered">
                                    <i class="stat-icon icon-lg zmdi zmdi-notifications"></i>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-md-3 col-sm-6 col-xs-12">
                    <a href="{{ route('superadmin.tickets.asignados.index') }}">
                        <div class="databox bg-white radius-bordered">
                            <div class="databox-left bg-themeAsignados">
                                <div class="databox-piechart">
                                    <div data-toggle="easypiechart" class="easyPieChart" data-barcolor="#fff"
                                         data-linecap="butt"
                                         data-percent="{{ isset($reportEasyTickets['asignados']) ? $reportEasyTickets['asignados']['porcentaje'] : '0' }}"
                                         data-animate="500" data-linewidth="3"
                                         data-size="47" data-trackcolor="rgba(255,255,255,0.2)">
                                    <span class="white font-90">{{ isset($reportEasyTickets['asignados']) ? $reportEasyTickets['asignados']['porcentaje'] : '0' }}%</span>
                                    </div>
                                </div>
                            </div>
                            <div class="databox-right">
                                <span class="databox-number themeAsignados">{{ isset($reportEasyTickets['asignados']) ? $reportEasyTickets['asignados']['cantidad'] : 0 }}</span>
                                <div class="databox-text darkgray">ASIGNADOS</div>
                                <div class="databox-stat themeAsignados radius-bordered">
                                    <i class="stat-icon icon-lg zmdi zmdi-account-circle"></i>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-md-3 col-sm-6 col-xs-12">
                    <a href="{{ route('superadmin.tickets.conincidencias.index') }}">
                        <div class="databox bg-white radius-bordered">
                            <div class="databox-left bg-themeConIncidencias">
                                <div class="databox-piechart">
                                    <div data-toggle="easypiechart" class="easyPieChart" data-barcolor="#fff"
                                         data-linecap="butt"
                                         data-percent="{{ isset($reportEasyTickets['conIncidencias']) ? $reportEasyTickets['conIncidencias']['porcentaje'] : '0' }}"
                                         data-animate="500" data-linewidth="3"
                                         data-size="47" data-trackcolor="rgba(255,255,255,0.2)">
                                    <span class="white font-90">{{ isset($reportEasyTickets['conIncidencias']) ? $reportEasyTickets['conIncidencias']['porcentaje'] : '0' }}%</span>
                                    </div>
                                </div>
                            </div>
                            <div class="databox-right">
                                <span class="databox-number themeConIncidencias">{{ isset($reportEasyTickets['conIncidencias']) ? $reportEasyTickets['conIncidencias']['cantidad'] : 0 }}</span>
                                <div class="databox-text darkgray">CON INCIDENCIAS</div>
                                <div class="databox-stat themeConIncidencias radius-bordered">
                                    <i class="stat-icon icon-lg zmdi zmdi-fire"></i>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-md-3 col-sm-6 col-xs-12">
                    <a href="{{ route('superadmin.tickets.atendidos.index') }}">
                        <div class="databox bg-white radius-bordered">
                            <div class="databox-left bg-themeAtendidos">
                                <div class="databox-piechart">
                                    <div id="users-pie" data-toggle="easypiechart" class="easyPieChart"
                                         data-barcolor="#fff"
                                         data-linecap="butt"
                                         data-percent="{{ isset($reportEasyTickets['atendidos']) ? $reportEasyTickets['atendidos']['porcentaje'] : '0' }}"
                                         data-animate="500" data-linewidth="3"
                                         data-size="47" data-trackcolor="rgba(255,255,255,0.1)">
                                    <span class="white font-90">{{ isset($reportEasyTickets['atendidos']) ? $reportEasyTickets['atendidos']['porcentaje'] : '0' }}%</span>
                                    </div>
                                </div>
                            </div>
                            <div class="databox-right">
                                <span class="databox-number themeAtendidos">{{ isset($reportEasyTickets['atendidos']) ? $reportEasyTickets['atendidos']['cantidad'] : 0 }}</span>
                                <div class="databox-text darkgray">ATENDIDOS</div>
                                <div class="databox-stat radius-bordered">
                                    <i class="stat-icon icon-lg zmdi zmdi-check-circle themeAtendidos"></i>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>

            </div>
        </div>
    </div>
    <style>
        .databox-text {
            font-weight: bold;
        }
    </style>
@endsection
@section('scripts')
    <script>
        $(function () {
            InitiateEasyPieChart.init();
        });
    </script>
@stop