@extends('superadmin.layouts.template')
@section('title', 'Módulo de Tickets - Con Incidencias')
@section('content')
    @include('superadmin.layouts.partials.breadcrumbs')
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>Módulo de Tickets - Con Incidencias</h1>
        </div>
        <div class="header-buttons">
            @include('superadmin.layouts.partials.headerbuttons')
        </div>
    </div>
    <div class="page-body">
        <div class="row">
            <div class="col-md-12">
                <div class="widget">
                    <div class="widget-header ">
                        <span class="widget-caption">Módulo de Tickets - Con Incidencias</span>
                        <div class="widget-buttons">
                            @include('superadmin.layouts.partials.widgetbutton')
                        </div>
                    </div>
                    <div class="widget-body">
                        <div class="table-responsive row-none" id="resultado_filtro">
                            <table id="tablaListado" class="table table-striped table-bordered table-hover">
                                <thead class="headTablaListado">
                                <tr class="text-uppercase text-center th-head-inputs">
                                    <th>N°</th>
                                    <th>Usuario</th>
                                    <th>Ticket</th>
                                    <th>Asunto</th>
                                    <th>Categoria</th>
                                    <th>Tipo</th>
                                    <th>Fecha creación</th>
                                    <th>Atendiendo por</th>
                                    <th>Acciones</th>
                                </tr>
                                </thead>
                                <tfoot class="footTablaListado">
                                <tr class="text-uppercase">
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php $n = 1?>
                                @foreach($tickets as $ticket)
                                    <tr>
                                        <td class="text-center">{{ $n++ }}</td>
                                        <td class="">{{ $ticket->persona->apellidos_nombres }}</td>
                                        <td class="">{{ $ticket->ticket->codigo }}</td>
                                        <td class="">{{ $ticket->ticket->asunto }}</td>
                                        <td class="">{{ $ticket->ticket->categoriaTicket->nombre }}</td>
                                        <td class="">{{ $ticket->ticket->tipoTicket->nombre }}</td>
                                        <td class="text-center">{!! formatDateHour($ticket->fecha_inicio_conincidencia) !!}</td>
                                        <td class="" width="100">{{ $ticket->asignado->last_first_name }}</td>
                                        <td class="text-center">
                                            <div class="btn-group">
                                                <a class="btn btn-primary dropdown-toggle btn-sm"
                                                   data-toggle="dropdown">
                                                    Acciones <i class="fa fa-angle-down"></i>
                                                </a>
                                                <ul class="dropdown-menu pull-right">
                                                    <li>
                                                        <a href="{{ route('superadmin.tickets.conincidencias.detalle', [$ticket->ticket->codigo]) }}"
                                                           class=""
                                                           data-toggle="modal"
                                                           data-target="#openModal"
                                                           data-tamanio="lg">
                                                            <i class="zmdi zmdi-eye"></i>
                                                            Detalle
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $(function () {
            tablaListadoDataTable();
        });
    </script>
@stop