<div class="col-sm-12 col-md-12">
    <div class="col-sm-5 col-md-5">
        <div class="col-sm-8 col-md-8">
            <div class="form-group fg-line">
                {!! Form::label('nombre', 'Nombre', ['class' => '']) !!}
                {!! Form::text('nombre',(isset($sede) ? $sede->nombre : null),['class'=>'form-control input-sm', 'id'=>'nombre', 'placeholder'=>'Nombre']) !!}
            </div>
        </div>
        <div class="col-sm-4 col-md-4">
            <div class="form-group fg-line">
                {!! Form::label('prefijo', 'Prefijo', ['class' => '']) !!}
                {!! Form::text('prefijo',(isset($sede) ? $sede->prefijo : null),['class'=>'form-control input-sm text-uppercase', 'id'=>'prefijo', 'placeholder'=>'Prefijo','maxlength'=>3]) !!}
            </div>
        </div>
        <div class="col-sm-12 col-md-12">
            <div class="form-group fg-line">
                {!! Form::label('direccion', 'Dirección', ['class' => '']) !!}
                {!! Form::text('direccion',(isset($sede) ? $sede->direccion : null),['class'=>'form-control input-sm','id'=>'direccion','placeholder'=>'Dirección']) !!}
            </div>
        </div>
        <div class="col-sm-6 col-md-6">
            <div class="form-group fg-line">
                {!! Form::label('latitud', 'Latitud', ['class' => '']) !!}
                {!! Form::text('latitud',(isset($sede) ? $sede->latitud : null),['class'=>'form-control input-sm','id'=>'latitud','placeholder'=>'Latitud','readonly'=>true]) !!}
            </div>
        </div>
        <div class="col-sm-6 col-md-6">
            <div class="form-group fg-line">
                {!! Form::label('longitud', 'Longitud', ['class' => '']) !!}
                {!! Form::text('longitud',(isset($sede) ? $sede->longitud : null),['class'=>'form-control input-sm','id'=>'longitud','placeholder'=>'Longitud','readonly'=>true]) !!}
            </div>
        </div>
    </div>
    <div class="col-sm-7 col-md-7">
        <div class="col-sm-12 col-md-12">
            <div class="form-group fg-line">
                <label for="map_canvas">MAPA (Para apreciar el punto, arrastar el streetView <i
                            class="zmdi zmdi-walk"></i>
                    )</label>
                <div id="map_canvas"></div>
            </div>
        </div>
    </div>

</div>
@section('scripts')
    <script src="https://maps.google.com/maps/api/js?key=AIzaSyAkPejC9WadRuaoGy1BpCSUigytpIA-pJ4&libraries=places,geometry"></script>
    <script>
        var markers = [];
        var i, autocomplete, map, bounds, geocoder;
        $(function () {
            var input = document.getElementById('direccion');
            google.maps.event.addDomListener(input, 'keydown', function (event) {
                if (event.keyCode === 13) {
                    event.preventDefault();
                }
            });
            initialize();
        });

        function initialize() {
            var lat_ = $("#latitud").val();
            var lng_ = $("#longitud").val();
            var myLatLng = new google.maps.LatLng(lat_, lng_);
            geocoder = new google.maps.Geocoder();
            var myOptions = {
                zoom: 15,
                center: myLatLng,
                mapTypeId: 'roadmap'
            };
            map = new google.maps.Map($('#map_canvas')[0], myOptions);
            var ima = image_();
            var marker_ = new google.maps.Marker({
                map: map,
                icon: ima
            });
            geocoder.geocode({latLng: myLatLng}, function (results, status) {
                if (status === google.maps.GeocoderStatus.OK) {
                    if (results[0]) {
                        map.fitBounds(results[0].geometry.viewport);
                        marker_.setPosition(myLatLng);
                        $('#direccion').text(results[0].formatted_address);
                    }
                }
            });

            var dirOrigen = document.getElementById('direccion');
            dirOrigen.addEventListener('focus', function () {
                map_autocomplete('direccion');
            }, true);
            function map_autocomplete(id_) {
                var options = {
                    componentRestrictions: {country: "pe"}
                };
                autocomplete = new google.maps.places.Autocomplete((document.getElementById(id_)), options);
                autocomplete.bindTo('bounds', map);

                google.maps.event.addListener(autocomplete, 'place_changed', function () {
                    fillInAddress();
                });
            }
        }

        function fillInAddress() {
            deleteMarkers();
            var place = autocomplete.getPlace();
            var mylatLng = new google.maps.LatLng(place.geometry.location.lat(), place.geometry.location.lng());
            $("#latitud").val(place.geometry.location.lat());
            $("#longitud").val(place.geometry.location.lng());
            var image = image_();
            var marker = new google.maps.Marker({
                position: place.geometry.location,
                map: map,
                icon: image,
                optimized: false,
                visible: true,
                flat: true
            });
            map.setCenter(mylatLng);
            map.setZoom(16);
            markers.push(marker);
        }

        function deleteMarkers() {
            for (var i = 0; i < markers.length; i++) {
                markers[i].setMap(null);
                markers = [];
            }
        }

        function image_() {
            return {
                path: google.maps.SymbolPath.CIRCLE,
                scale: 10, //tamaño
                strokeColor: '#E3F2FD', //color del borde
                strokeWeight: 5, //grosor del borde
                strokeOpacity: 0.8,
                fillColor: "#1E88E5",
                fillOpacity: 1// opacidad del relleno
            };
//            return image;
        }
    </script>
@stop