@extends('superadmin.layouts.template')
@section('title', 'Módulo de Sedes')
@section('content')
    @include('superadmin.layouts.partials.breadcrumbs')
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>Módulo de Sedes</h1>
        </div>
        <div class="header-buttons">
            <a class="" href="{{ route('superadmin.sedes.create') }}">
                <i class="zmdi zmdi-plus-circle"></i>
            </a>
            @include('superadmin.layouts.partials.headerbuttons')
        </div>
    </div>
    <div class="page-body">
        <div class="row">
            <div class="col-md-12">

                <div class="widget">
                    <div class="widget-header ">
                        <span class="widget-caption">Listado de Sedes</span>
                        <div class="widget-buttons">
                            @include('superadmin.layouts.partials.widgetbutton')
                        </div>
                    </div>
                    <div class="widget-body">
                        <div class="table-responsive row-none" id="resultado_filtro">
                            <table id="tablaListado" class="table table-striped table-bordered table-hover">
                                <thead class="headTablaListado">
                                <tr class="text-uppercase text-center th-head-inputs">
                                    <th>N°</th>
                                    <th>Nombre</th>
                                    <th>Dirección</th>
                                    <th>Latitud - Longitud</th>
                                    <th>areas</th>
                                    <th>Acciones</th>
                                </tr>
                                </thead>
                                <tfoot class="footTablaListado">
                                <tr class="text-uppercase">
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php $n = 1?>
                                @foreach($sedes as $sede)
                                    <tr>
                                        <td class="text-center">{{ $n++ }}</td>
                                        <td class="child-text-delete">{{ $sede->nombre }}</td>
                                        <td class="text-left">{{ $sede->direccion }}</td>
                                        <td class="text-center">{{ $sede->latitud. " - ". $sede->longitud }}</td>
                                        <td class="text-center">
                                            <a href="javascript:;"
                                               class="btn btn-purple shiny btn-circle btn-xs"
                                               data-toggle='modal'
                                               data-target="#openModal"
                                               data-tamanio='sm'>
                                                {{ $sede->areas_count }}
                                            </a>
                                        </td>
                                        <td class="text-center">

                                            <div class="btn-group">
                                                <button type="button" class="btn btn-primary dropdown-toggle"
                                                        data-toggle="dropdown">
                                                    Acciones
                                                    <span class="caret"></span>
                                                </button>
                                                <ul class="dropdown-menu pull-right" role="menu">
                                                    <li>
                                                        <a href="{{ route('superadmin.sedes.show',$sede->slug) }}"
                                                           class="">
                                                            <i class="zmdi zmdi-eye"></i>
                                                            Detalle
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="{{ route('superadmin.sedes.edit',$sede->slug) }}"
                                                           class="">
                                                            <i class="zmdi zmdi-edit"></i>
                                                            Editar
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="javascript:;"
                                                           data-csrf="{{ csrf_token() }}"
                                                           data-id="{{ $sede->id }}"
                                                           data-mensaje =" la sede "
                                                           data-href="{{ route('superadmin.sedes.delete',$sede->id) }}"
                                                           class="delete-item">
                                                            <i class="zmdi zmdi-close"></i>
                                                            Eliminar
                                                        </a>
                                                    </li>

                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $(function () {
            tablaListadoDataTable();
        });
    </script>
@stop