@extends('superadmin.layouts.template')
@section('title', 'Recursos Humanos')
@section('content')
    @include('superadmin.layouts.partials.breadcrumbs')
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>Recursos Humanos</h1>
        </div>
        <div class="header-buttons">
            <a class="icono-info" href="{{ route('superadmin.recursoshumanos.subirarchivos') }}">
                <i class="zmdi zmdi-plus-circle"></i>
            </a>
            @include('superadmin.layouts.partials.headerbuttons')
        </div>
    </div>
    <div class="page-body">
        <div class="row">
            <div class="col-md-12">

                <div class="widget">
                    <div class="widget-header ">
                        <span class="widget-caption">Listado de Archivos subidos</span>
                        <div class="widget-buttons">
                            @include('superadmin.layouts.partials.widgetbutton')
                        </div>
                    </div>
                    <div class="widget-body">
                        <div class="table-responsive row-none" id="resultado_filtro">
                            <table id="tablaListado" class="table table-striped table-bordered table-hover">
                                <thead class="headTablaListado">
                                <tr class="text-uppercase text-center th-head-inputs">
                                    <th>N°</th>
                                    <th>Nombre Original</th>
                                    <th>Archivo</th>
                                    <th>Acciones</th>
                                </tr>
                                </thead>
                                <tfoot class="footTablaListado">
                                <tr class="text-uppercase">
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php $n = 1?>
                                @foreach($archivos as $archivo)
                                    <tr>
                                        <td class="text-center">{{ $n++ }}</td>
                                        <td class="text-left child-text-delete">{{ $archivo->original_name }}</td>
                                        <td class="text-left">{{ $archivo->filename }}</td>
                                        <td class="text-center">

                                            <div class="btn-group">
                                                <button type="button" class="btn btn-primary dropdown-toggle"
                                                        data-toggle="dropdown">
                                                    Acciones
                                                    <span class="caret"></span>
                                                </button>
                                                <ul class="dropdown-menu pull-right" role="menu">
                                                    <li>
                                                        <a href="{{ asset('web/rrhh/'.$archivo->filename) }}"
                                                           class="" target="_blank">
                                                            <i class="zmdi zmdi-eye"></i>
                                                            Detalle
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="javascript:;"
                                                           data-csrf="{{ csrf_token() }}"
                                                           data-id="{{ $archivo->id }}"
                                                           data-mensaje=" el archivo "
                                                           data-href="{{ route('superadmin.recursoshumanos.eliminararchivos',$archivo->id) }}"
                                                           class="delete-item">
                                                            <i class="zmdi zmdi-close"></i>
                                                            Eliminar
                                                        </a>
                                                    </li>

                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $(function () {
            tablaListadoDataTable();
        });
    </script>
@stop