<div class="col-md-3">
    <div class="widget flat radius-bordered">
        <div class="widget-header bg-blue">
            <span class="widget-caption">Foto de la Persona</span>
        </div>
        <div class="widget-body">
            <div class="row">
                <div class="col-md-12 col-sm-12 text-center">
                    <div class="divPreviews"></div>
                    <span class="file-input btn btn-azure btn-file m-t-20 d-block">
                        Seleccionar Foto <input type="file" id="foto" name="foto" accept="image/x-png,image/jpeg">
                    </span>
                    {!! Form::hidden('foto_old',(isset($persona)? $persona->foto : null )) !!}
                </div>
            </div>
        </div>
    </div>
</div>
<div class="col-md-9">
    <div class="widget flat radius-bordered">
        <div class="widget-header bg-blue">
            <span class="widget-caption">Datos de la Persona</span>
        </div>
        <div class="widget-body">
            <div class="row">
                <div class="col-md-12 col-sm-12">
                    <div class="col-sm-4 col-md-4">
                        <div class="form-group fg-line {{ $errors->has('sede_id') ? 'has-error' : '' }}">
                            {!! Form::label('sede_id', 'Sede', ['class' => '']) !!}
                            {!! Form::select('sede_id', $sedes, (isset($persona) ? $persona->sede_id : null), ['class'=>'form-control input-sm select','id'=>'sede_id','placeholder'=>'Seleccione']) !!}
                            <span class="text-danger">{{ $errors->first('sede_id') }}</span>
                        </div>
                    </div>
                    <div class="col-sm-4 col-md-4">
                        <div class="form-group fg-line {{ $errors->has('area_id') ? 'has-error' : '' }}">
                            {!! Form::label('area_id', 'Área', ['class' => '']) !!}
                            {!! Form::select('area_id', $areas, (isset($persona) ? $persona->area_id : null), ['class'=>'form-control input-sm select load-area','id'=>'area_id','placeholder'=>'Seleccione']) !!}
                            <span class="text-danger">{{ $errors->first('area_id') }}</span>
                        </div>
                    </div>
                    <div class="col-sm-4 col-md-4">
                        <div class="form-group fg-line {{ $errors->has('cargo_id') ? 'has-error' : '' }}">
                            {!! Form::label('cargo_id', 'Cargo', ['class' => '']) !!}
                            {!! Form::select('cargo_id', $cargos, (isset($persona) ? $persona->cargo_id : null), ['class'=>'form-control input-sm select load-cargo','id'=>'cargo_id','placeholder'=>'Seleccione']) !!}
                            <span class="text-danger">{{ $errors->first('cargo_id') }}</span>
                        </div>
                    </div>
                </div>
                <div class="col-md-12 col-sm-12">
                    <div class="col-sm-3 col-md-3">
                        <div class="form-group fg-line {{ $errors->has('dni') ? 'has-error' : '' }}">
                            {!! Form::label('dni', 'D.N.I', ['class' => '']) !!}
                            <span class="input-icon icon-right">
                            {!! Form::text('dni',(isset($persona) ? $persona->dni: null),['class'=>'form-control input-sm onlyNumbers','id'=>'dni','placeholder'=>'D.N.I', 'maxlength'=>12]) !!}
                                <i class="fa fa-code circular"></i>
                            </span>
                            <span class="text-danger">{{ $errors->first('dni') }}</span>
                        </div>
                    </div>
                    <div class="col-sm-9 col-md-9">
                        <div class="form-group fg-line {{ $errors->has('apellidos_nombres') ? 'has-error' : '' }}">
                            {!! Form::label('apellidos_nombres', 'Apellidos y Nombres', ['class' => '']) !!}
                            <span class="input-icon icon-right">
                                {!! Form::text('apellidos_nombres',(isset($persona) ? $persona->apellidos_nombres : null),['class'=>'form-control input-sm','id'=>'apellidos_nombres','placeholder'=>'Nombres y Apellidos']) !!}
                                <i class="glyphicon glyphicon-user circular"></i>
                            </span>
                            <span class="text-danger">{{ $errors->first('apellidos_nombres') }}</span>
                        </div>
                    </div>

                </div>
                <div class="col-md-12 col-sm-12">
                    <div class="col-sm-4 col-md-4">
                        <div class="form-group fg-line {{ $errors->has('email') ? 'has-error' : '' }}">
                            {!! Form::label('email', 'E-mail', ['class' => '']) !!}
                            <span class="input-icon icon-right">
                                {!! Form::email('email',(isset($persona) ? $persona->email: null),['class'=>'form-control input-sm','id'=>'email','placeholder'=>'E-mail']) !!}
                                <i class="fa fa-envelope-o circular"></i>
                            </span>
                            <span class="text-danger">{{ $errors->first('email') }}</span>
                        </div>
                    </div>
                    <div class="col-sm-3 col-md-3">
                        <div class="form-group fg-line {{ $errors->has('telefono_empresa') ? 'has-error' : '' }}">
                            {!! Form::label('telefono_empresa', 'Tel. Empresa', ['class' => '']) !!}
                            <span class="input-icon icon-right">
                                {!! Form::text('telefono_empresa',(isset($persona) ? $persona->telefono_empresa : null),['class'=>'form-control input-sm','id'=>'telefono_empresa','placeholder'=>'Tel. Empresa','maxlength'=>9]) !!}
                                <i class="glyphicon glyphicon-phone circular"></i>
                            </span>
                            <span class="text-danger">{{ $errors->first('telefono_empresa') }}</span>
                        </div>
                    </div>
                    <div class="col-sm-3 col-md-3">
                        <div class="form-group fg-line {{ $errors->has('telefono_personal') ? 'has-error' : '' }}">
                            {!! Form::label('telefono_personal', 'Tel. Personal', ['class' => '']) !!}
                            <span class="input-icon icon-right">
                                {!! Form::text('telefono_personal',(isset($persona) ? $persona->telefono_personal : null),['class'=>'form-control input-sm','id'=>'telefono_personal','placeholder'=>'Tel. Personal','maxlength'=>9]) !!}
                                <i class="glyphicon glyphicon-phone circular"></i>
                            </span>
                            <span class="text-danger">{{ $errors->first('telefono_personal') }}</span>
                        </div>
                    </div>
                    <div class="col-sm-2 col-md-2">
                        <div class="form-group fg-line {{ $errors->has('anexo') ? 'has-error' : '' }}">
                            {!! Form::label('anexo', 'Anexo', ['class' => '']) !!}
                            {!! Form::text('anexo',(isset($persona) ? $persona->anexo: null),['class'=>'form-control input-sm onlyNumbers','id'=>'anexo','placeholder'=>'Anexo','maxlength'=>4]) !!}
                        </div>
                        <span class="text-danger">{{ $errors->first('anexo') }}</span>
                    </div>
                </div>
                <div class="col-md-12 colo-sm-12">
                    <div class="col-sm-3 col-md-3">
                        <div class="form-group fg-line m-b-0 ">
                            {!! Form::label('fecha_nacimiento', 'Fecha Nacimiento', ['class' => '']) !!}
                        </div>
                        <div class="input-group m-b-15 {{ $errors->has('fecha_nacimiento') ? 'has-error' : '' }}">
                            {!! Form::text('fecha_nacimiento',(isset($persona) ? $persona->fecha_nacimiento : null),['class'=>'form-control input-sm','id'=>'fecha_nacimiento','placeholder'=>date('d-m-Y'), 'data-mask'=>"99-99-9999"]) !!}
                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                            <span class="text-danger">{{ $errors->first('fecha_nacimiento') }}</span>
                        </div>
                    </div>
                    <div class="col-sm-3 col-md-3">
                        <div class="form-group fg-line {{ $errors->has('genero') ? 'has-error' : '' }}">
                            {!! Form::label('genero', 'Genero', ['class' => '']) !!}
                            {!! Form::select('genero', $genero, (isset($persona) ? $persona->genero : null), ['class'=>'form-control input-sm select','id'=>'genero']) !!}
                            <span class="text-danger">{{ $errors->first('genero') }}</span>
                        </div>
                    </div>
                    <div class="col-sm-3 col-md-3">
                        <div class="form-group fg-line m-b-0 {{ $errors->has('estado_civil') ? 'has-error' : '' }}">
                            {!! Form::label('estado_civil', 'Estado Civil', ['class' => '']) !!}
                            {!! Form::select('estado_civil', $estadoCivil, (isset($persona) ? $persona->estado_civil : null), ['class'=>'form-control input-sm select','id'=>'estado_civil']) !!}
                            <span class="text-danger">{{ $errors->first('estado_civil') }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<style>
    .divPreviews {
        width: 180px;
        height: 180px;
        background-position: center !important;
        background-size: cover !important;
        background-repeat: no-repeat;
        -webkit-box-shadow: 0 0 1px 1px rgba(0, 0, 0, .3);
        -moz-box-shadow: 0 0 1px 1px rgba(0, 0, 0, .3);
        box-shadow: 0 0 1px 1px rgba(0, 0, 0, .3);
        display: inline-block;
        -moz-border-radius: 50%;
        -webkit-border-radius: 50%;
        border-radius: 50%;
    }
</style>
<script>
    $(function () {
        @if(isset($persona) && ($persona->foto != null || $persona->foto != "" ))
        var url_file = "{{ asset('web/perfil/thumbnail/thumb-'.$persona->foto) }}";
        $('.divPreviews').css("background-image", 'url(' + url_file + ')');
        @endif

        $("#foto").change(function () {
            var file = this.files[0];
            var createFileImage = window.URL.createObjectURL(file);
            $('.divPreviews').css("background-image", 'url(' + window.URL.createObjectURL(file) + ')');
        });
    });
</script>