@extends('superadmin.layouts.template')
@section('title', 'Tarjeta permiso de cumpleaño')
@section('content')
    @include('superadmin.layouts.partials.breadcrumbs')

    <div class="page-header position-relative">
        <div class="header-title">
            <h1>
                <i class="zmdi zmdi-cake"></i> Tarjeta permiso de cumpleaño
            </h1>
        </div>
        <div class="header-buttons">
            <a class="" href="javascript:;" onClick="window.print()">
                <i class="zmdi zmdi-print"></i>
            </a>
            @include('superadmin.layouts.partials.headerbuttons')
        </div>
    </div>
    <div class="page-body" id="imprimir-contenido">
        <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="well invoice-container">
                    <div class="invoice-logo">
                        <div class="row">
                            <div class="col-xs-4 col-sm-4 col-md-4 text-center">
                                {{ Html::image('assets/email/logos/cvp.jpg','image-cvp',['class'=>'check-image']) }}
                            </div>
                            <div class="col-xs-4 col-sm-4 col-md-4 text-center m-t-10">
                                {{ Html::image('assets/email/logos/telecom.png','image-telecom',['class'=>'check-image']) }}
                            </div>
                            <div class="col-xs-4 col-sm-4 col-md-4 text-center">
                                {{ Html::image('assets/email/logos/utv.png','image-utv',['class'=>'check-image']) }}
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-4">
                            <div class="panel panel-default panel-altura">
                                <div class="panel-heading">
                                    <h6>Personal</h6>
                                </div>
                                <div class="panel-body">
                                    <ul>
                                        <li><i class="zmdi zmdi-account-circle"></i> {{ $persona->apellidos_nombres }}
                                        </li>
                                        <li><i class="zmdi zmdi-pin"></i> {{ $persona->sede->nombre }}</li>
                                        <li><i class="zmdi zmdi-view-column"></i> {{ $persona->area->nombre }}</li>
                                        <li><i class="zmdi zmdi-account-box"></i> {{ $persona->cargo->nombre }}</li>
                                        <li>
                                            <i class="zmdi zmdi-calendar"></i> {{ dateCarbon($persona->fecha_nacimiento)}}
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-8">
                            <div class="">
                                <div class="panel panel-default panel-altura ">
                                    <div class="panel-heading">
                                        <h6>Autorizado por</h6>
                                    </div>
                                    <div class="panel-body text-center panel-body-firmas">
                                        <div class="row">
                                            <div class="col-xs-4">
                                                <div class="firma-autorizada">
                                                    {{ $persona->apellidos_nombres }}<br>
                                                    DNI: {{ $persona->dni }}
                                                </div>
                                            </div>
                                            <div class="col-xs-4">
                                                <div class="firma-autorizada">
                                                    JEFE DIRECTO
                                                </div>
                                            </div>
                                            <div class="col-xs-4">
                                                <div class="firma-autorizada">
                                                    RECURSOS HUMANOS
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <hr class="wide"/>
                    <div class="invoice-notes">
                        <h5>En el mes de tu cumpleaños</h5>
                        <div class="row">
                            <div class="col-xs-6">
                                <p>Es nuestro deseo que durante estos días, logres avanzar
                                    en tus planes y alcances el éxito en todo aquello que te
                                    propongas. Haz que este mes sea el
                                    mejor del año.</p>
                                <p>Esperamos que no falten los buenos momentos en
                                    compañía de las personas que más quieres.
                                    Recuerda que siempre estamos a tu lado cuando
                                    más nos necesites.</p>
                            </div>
                            <div class="col-xs-6 text-center">
                                {{--<div class="col-xs-4 col-sm-4 col-md-4 text-center">--}}
                                {{ Html::image('assets/email/cumpleanio/feliz_cumple.png','feliz-cumple',['class'=>'']) }}
                                {{--</div>--}}
                            </div>
                        </div>
                        <hr class="wide"/>
                        <div class="invoice-logo-copy text-center">
                            <img src="" class="image-recargar">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <style>
        .invoice-logo {
            margin-bottom: 20px;
        }

        .check-image {
            cursor: pointer;
        }

        .firma-autorizada {
            border-top: 1px solid #e5e5e5;
            margin-top: 50px;
            font-size: 10px;
        }

        .panel-altura {
            height: 190px;
        }

        .panel-body-firmas {
            position: absolute;
            left: 0;
            right: 0;
            bottom: 30px;
        }

        @media print {
            @page {
                margin: 0.2cm;
                size: portrait
            }

            #imprimir-contenido {
                background-color: white;
                height: 100%;
                width: 100%;
                position: fixed;
                top: 0;
                left: 0;
                margin: 0;
                padding: 15px;
                font-size: 14px;
                line-height: 18px;
            }

            .invoice-logo,
            .panel-body ul li i,
            .page-breadcrumbs,
            .page-header,
            .page-sidebar {
                display: none;
            }
        }
    </style>
@endsection
@section('scripts')
    <script>
        $(function () {
            $(document).on('click', '.check-image', function () {
                console.log("imageALT:::", $(this).prop('alt'));
                console.log("imageSRC:::", $(this).prop('src'));
                $(".image-recargar").prop("src", $(this).prop('src'));
            });
        });
    </script>
@stop