@extends('superadmin.layouts.template')
@section('title', 'Módulo de Cumpleaños')
@section('content')
    @include('superadmin.layouts.partials.breadcrumbs')
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>
                <i class="zmdi zmdi-cake"></i> Módulo de Cumpleaños
            </h1>
        </div>
        <div class="header-buttons">
            @include('superadmin.layouts.partials.headerbuttons')
        </div>
    </div>
    <div class="page-body">
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="row">
                    @if(count($personas) > 0)
                        @foreach($personas as $persona)
                            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12 {{ verificaCumple($persona->fecha_nacimiento) ? "animated infinite pulse" : "" }}">
                                <a href="{{ verificaCumple($persona->fecha_nacimiento) ? route('superadmin.cumpleanios.personal.show', [$persona->slug]) : "javascript:;" }}"
                                   class="" style=""
                                   data-toggle="modal"
                                   data-target="#openModal"
                                   data-tamanio="sm">
                                    <div class="databox bg-white radius-bordered">
                                        <div class="databox-left no-padding">
                                            {{ Html::image(loadPhotoProfile($persona->foto,$persona->genero), $persona->apellidos_nombres,['class'=>'img-avatar-cumpleanio']) }}
                                        </div>
                                        <div class="databox-right">
                                            <div class="databox-text darkgray ellipsis">{{ $persona->apellidos_nombres }}</div>
                                            <div class="databox-text darkgray">{{ dateCarbon($persona->fecha_nacimiento) }}</div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </div>
    <style>
        .img-avatar-cumpleanio {
            width: 65px;
            height: 65px;
            padding: 5px;
            border-radius: 50%;
            -webkit-border-radius: 50%;
            -moz-border-radius: 50%;
        }

        /*.ellipsiss {*/
        /*white-space: nowrap;*/
        /*overflow: hidden;*/
        /*text-overflow: ellipsis;*/
        /*}*/
    </style>
@endsection
@section('scripts')
    <script>
        $(function () {
        });
    </script>
@stop