<?php
$reportes = Config::get('constants.reportes');
?>
@extends('superadmin.layouts.template')
@section('title', 'Reportes')
@section('content')
    @include('superadmin.layouts.partials.breadcrumbs')
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>Reportes</h1>
        </div>
        <div class="header-buttons">
            @include('superadmin.layouts.partials.headerbuttons')
        </div>
    </div>
    <div class="page-body">
        <div class="row">
            <div class="col-md-12">
                @foreach($reportes as $key => $value)
                    <div class="col-md-3 col-xs-6">
                        <a href="{{ route("superadmin.herramientas.reportes.".$value['route'].".index") }}"
                           class="d-block">
                            <div class="databox databox-lg databox-vertical databox-inverted bg-white databox-shadowed databox-portrait">
                                <div class="databox-top">
                                    <i class="zmdi zmdi-{{$value['icon']}} portada_zmdi"></i>
                                </div>
                                <div class="databox-bottom no-padding text-align-center">
                                    <span class="databox-text lightcarbon no-margin">{{$value['text']}}</span>
                                </div>
                            </div>
                        </a>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
@endsection