@extends('superadmin.layouts.template')
@section('title', 'Sub-Listas de '.ucwords(mb_strtolower($lista->nombre, 'UTF-8')))
@section('content')
    @include('superadmin.layouts.partials.breadcrumbs')
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>Sub-Listas de {{ ucwords(mb_strtolower($lista->nombre, 'UTF-8')) }}</h1>
        </div>
        <div class="header-buttons">
            <a class="add-register" href="{{ route('superadmin.herramientas.listas.sublista.crear',$lista->slug) }}"
               data-toggle="modal"
               data-target="#openModal"
               data-tamanio="sm">
                <i class="zmdi zmdi-plus-circle"></i>
            </a>
            @include('superadmin.layouts.partials.headerbuttons')
        </div>
    </div>
    <div class="page-body">
        <div class="row">
            <div class="col-md-12">

                <div class="widget">
                    <div class="widget-header ">
                        <span class="widget-caption">
                            Listado {{ ucwords(mb_strtolower($lista->nombre, 'UTF-8')) }} Sub-Lista</span>
                        <div class="widget-buttons">
                            @include('superadmin.layouts.partials.widgetbutton')
                        </div>
                    </div>
                    <div class="widget-body">
                        <div class="table-responsive row-none" id="resultado_filtro">
                            <table id="tablaListado" class="table table-striped table-bordered table-hover">
                                <thead class="headTablaListado">
                                <tr class="text-uppercase text-center th-head-inputs">
                                    <th>N°</th>
                                    <th>nombre</th>
                                    <th>Descripción</th>
                                    <th>Sub-Listas</th>
                                    <th>ACCIONES</th>
                                </tr>
                                </thead>
                                <tfoot class="footTablaListado">
                                <tr class="text-uppercase">
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php $n = 1?>
                                @foreach($subListas as $subLista)
                                    <tr>
                                        <td class="text-center">{{ $n++ }}</td>
                                        <td class="">{{ $subLista->nombre }}</td>
                                        <td class="">{{ $subLista->descripcion }}</td>
                                        <td class="text-center">
                                            <a href="{{ route('superadmin.herramientas.listas.sublista.sub.index',[$lista->slug, $subLista->slug]) }}"
                                               class="btn btn-purple shiny btn-circle btn-xs">
                                                {{ $subLista->sub_listas_count }}
                                            </a>
                                        </td>
                                        <td class="text-center">
                                            <div class="btn-group">
                                                <a class="btn btn-primary dropdown-toggle btn-sm"
                                                   data-toggle="dropdown">
                                                    Acciones <i class="fa fa-angle-down"></i>
                                                </a>
                                                <ul class="dropdown-menu pull-right">
                                                    {{--<li>--}}
                                                        {{--<a href="{{ route('superadmin.herramientas.listas.sublista.detalle', [$lista->slug, $subLista->slug]) }}"--}}
                                                           {{--class=""--}}
                                                           {{--data-toggle='modal'--}}
                                                           {{--data-target="#openModal"--}}
                                                           {{--data-tamanio='sm'>--}}
                                                            {{--<i class="zmdi zmdi-eye"></i>--}}
                                                            {{--Detalle--}}
                                                        {{--</a>--}}
                                                    {{--</li>--}}
                                                    <li>
                                                        <a href="{{ route('superadmin.herramientas.listas.sublista.editar', [$lista->slug, $subLista->slug]) }}"
                                                           class=""
                                                           data-toggle='modal'
                                                           data-target="#openModal"
                                                           data-tamanio='sm'>
                                                            <i class="zmdi zmdi-edit"></i>
                                                            Editar
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $(function () {
            tablaListadoDataTable();
        });
    </script>
@stop