@extends('superadmin.layouts.template')
@section('title', 'Módulo de Listas')
@section('content')
    @include('superadmin.layouts.partials.breadcrumbs')
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>Módulo de Listas</h1>
        </div>
        <div class="header-buttons">
            <a class="add-user" href="{{ route('superadmin.herramientas.listas.crear') }}"
               data-toggle="modal"
               data-target="#openModal"
               data-tamanio="sm">
                <i class="zmdi zmdi-plus-circle"></i>
            </a>
            @include('superadmin.layouts.partials.headerbuttons')
        </div>
    </div>
    <div class="page-body">
        <div class="row">
            <div class="col-md-12">
                <div class="widget">
                    <div class="widget-header ">
                        <span class="widget-caption">Módulo de Listas</span>
                        <div class="widget-buttons">
                            @include('superadmin.layouts.partials.widgetbutton')
                        </div>
                    </div>
                    <div class="widget-body">
                        <div class="table-responsive row-none" id="resultado_filtro">
                            <table id="tablaListado" class="table table-striped table-bordered table-hover">
                                <thead class="headTablaListado">
                                <tr class="text-uppercase text-center th-head-inputs">
                                    <th>N°</th>
                                    <th>Lista</th>
                                    <th>DESCRIPCIÓN</th>
                                    <th>Sub Listas</th>
                                    <th>Acciones</th>
                                </tr>
                                </thead>
                                <tfoot class="footTablaListado">
                                <tr class="text-uppercase">
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php $n = 1?>
                                @foreach($listas as $lista)
                                    <tr>
                                        <td class="text-center">{{ $n++ }}</td>
                                        <td class="">{{ $lista->nombre }}</td>
                                        <td class="">{{ $lista->descripcion }}</td>
                                        <td class="text-center">
                                            <a href="{{ route('superadmin.herramientas.listas.sublista.index',$lista->slug) }}"
                                               class="btn btn-purple shiny btn-circle btn-xs">
                                                {{ $lista->sub_listas_count }}
                                            </a>
                                        </td>
                                        <td class="text-center">
                                            <div class="btn-group">
                                                <a class="btn btn-primary dropdown-toggle btn-sm"
                                                   data-toggle="dropdown">
                                                    Acciones <i class="fa fa-angle-down"></i>
                                                </a>
                                                <ul class="dropdown-menu pull-right">
                                                    <li>
                                                        <a href="{{ route('superadmin.herramientas.listas.editar', [$lista->slug]) }}"
                                                           class=""
                                                           data-toggle='modal'
                                                           data-target="#openModal"
                                                           data-tamanio='sm'>
                                                            <i class="zmdi zmdi-edit"></i>
                                                            Editar
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $(function () {
            tablaListadoDataTable();
        });
    </script>
@stop