@extends('superadmin.layouts.template')
@section('title', 'Módulo de Cargos')
@section('content')
    @include('superadmin.layouts.partials.breadcrumbs')
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>Módulo de Cargos</h1>
        </div>
        <div class="header-buttons">
            <a class="" href="{{ route('superadmin.cargos.create') }}"
               data-toggle='modal'
               data-target="#openModal"
               data-tamanio='sm'>
                <i class="zmdi zmdi-plus-circle"></i>
            </a>
            @include('superadmin.layouts.partials.headerbuttons')
        </div>
    </div>
    <div class="page-body">
        <div class="row">
            <div class="col-md-12">

                <div class="widget">
                    <div class="widget-header ">
                        <span class="widget-caption">Listado de Cargos</span>
                        <div class="widget-buttons">
                            @include('superadmin.layouts.partials.widgetbutton')
                        </div>
                    </div>
                    <div class="widget-body">
                        <div class="table-responsive row-none" id="resultado_filtro">
                            <table id="tablaListado" class="table table-striped table-bordered table-hover">
                                <thead class="headTablaListado">
                                <tr class="text-uppercase text-center th-head-inputs">
                                    <th>N°</th>
                                    <th>Sede</th>
                                    <th>Área</th>
                                    <th>Cargo</th>
                                    <th>Personas</th>
                                    <th>Acciones</th>
                                </tr>
                                </thead>
                                <tfoot class="footTablaListado">
                                <tr class="text-uppercase">
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php $n = 1?>
                                @foreach($cargos as $cargo)
                                    <tr>
                                        <td class="text-center">{{ $n++ }}</td>
                                        <td class="text-left">{{ $cargo->sede->nombre }}</td>
                                        <td class="text-left">{{ $cargo->area->nombre }}</td>
                                        <td class="child-text-delete">{{ $cargo->nombre }}</td>
                                        <td class="text-center">
                                            <a href="javascript:;"
                                               class="btn btn-purple shiny btn-circle btn-xs"
                                               data-toggle='modal'
                                               data-target="#openModal"
                                               data-tamanio='sm'>
                                                {{ $cargo->personas_count }}
                                            </a>
                                        </td>
                                        <td class="text-center">

                                            <div class="btn-group">
                                                <button type="button" class="btn btn-primary dropdown-toggle"
                                                        data-toggle="dropdown">
                                                    Acciones
                                                    <span class="caret"></span>
                                                </button>
                                                <ul class="dropdown-menu pull-right" role="menu">
                                                    <li>
                                                        <a href="{{ route('superadmin.cargos.show',[ $cargo->slug, $cargo->area->id ]) }}"
                                                           class=""
                                                           data-toggle='modal'
                                                           data-target="#openModal"
                                                           data-tamanio='sm'>
                                                            <i class="zmdi zmdi-eye"></i>
                                                            Detalle
                                                        </a>

                                                    </li>
                                                    <li>
                                                        <a href="{{ route('superadmin.cargos.edit',[ $cargo->slug, $cargo->area->id ]) }}"
                                                           class=""
                                                           data-toggle='modal'
                                                           data-target="#openModal"
                                                           data-tamanio='sm'>
                                                            <i class="zmdi zmdi-edit"></i>
                                                            Editar
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="javascript:;"
                                                           data-csrf="{{ csrf_token() }}"
                                                           data-id="{{ $cargo->id }}"
                                                           data-mensaje=" el cargo "
                                                           data-href="{{ route('superadmin.cargos.delete',$cargo->id) }}"
                                                           class="delete-item">
                                                            <i class="zmdi zmdi-close"></i>
                                                            Eliminar
                                                        </a>
                                                    </li>


                                                </ul>
                                            </div>

                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $(function () {
            tablaListadoDataTable();
        });
    </script>
@stop