@extends('superadmin.layouts.template')
@section('title', 'Módulo de Áreas')
@section('content')
    @include('superadmin.layouts.partials.breadcrumbs')
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>Módulo de Áreas</h1>
        </div>
        <div class="header-buttons">
            <a class="" href="{{ route('superadmin.areas.create') }}"
               data-toggle='modal'
               data-target="#openModal"
               data-tamanio='sm'>
                <i class="zmdi zmdi-plus-circle"></i>
            </a>
            @include('superadmin.layouts.partials.headerbuttons')
        </div>
    </div>
    <div class="page-body">
        <div class="row">
            <div class="col-md-12">

                <div class="widget">
                    <div class="widget-header ">
                        <span class="widget-caption">Listado de Áreas</span>
                        <div class="widget-buttons">
                            @include('superadmin.layouts.partials.widgetbutton')
                        </div>
                    </div>
                    <div class="widget-body">
                        <div class="table-responsive row-none" id="resultado_filtro">
                            <table id="tablaListado" class="table table-striped table-bordered table-hover">
                                <thead class="headTablaListado">
                                <tr class="text-uppercase text-center th-head-inputs">
                                    <th>N°</th>
                                    <th>Sede</th>
                                    <th>Área</th>
                                    <th>Cargos</th>
                                    <th>Acciones</th>
                                </tr>
                                </thead>
                                <tfoot class="footTablaListado">
                                <tr class="text-uppercase">
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php $n = 1?>
                                @foreach($areas as $area)
                                    <tr>
                                        <td class="text-center">{{ $n++ }}</td>
                                        <td class="text-left">{{ $area->sede->nombre }}</td>
                                        <td class="child-text-delete">{{ $area->nombre }}</td>
                                        <td class="text-center">
                                            <a href="javascript:;"
                                               class="btn btn-purple shiny btn-circle btn-xs"
                                               data-toggle='modal'
                                               data-target="#openModal"
                                               data-tamanio='sm'>
                                                {{ $area->cargos_count }}
                                            </a>
                                        </td>
                                        <td class="text-center">

                                            <div class="btn-group">
                                                <button type="button" class="btn btn-primary dropdown-toggle"
                                                        data-toggle="dropdown">
                                                    Acciones
                                                    <span class="caret"></span>
                                                </button>
                                                <ul class="dropdown-menu pull-right" role="menu">
                                                    <li>
                                                        <a href="{{ route('superadmin.areas.show',[ $area->slug, $area->sede->id ]) }}"
                                                           class=""
                                                           data-toggle='modal'
                                                           data-target="#openModal"
                                                           data-tamanio='sm'>
                                                            <i class="zmdi zmdi-eye"></i>
                                                            Detalle
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="{{ route('superadmin.areas.edit',[ $area->slug, $area->sede->id ]) }}"
                                                           class=""
                                                           data-toggle='modal'
                                                           data-target="#openModal"
                                                           data-tamanio='sm'>
                                                            <i class="zmdi zmdi-edit"></i>
                                                            Editar
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="javascript:;"
                                                           data-csrf="{{ csrf_token() }}"
                                                           data-id="{{ $area->id }}"
                                                           data-mensaje=" el área "
                                                           data-href="{{ route('superadmin.areas.delete',$area->id) }}"
                                                           class="delete-item">
                                                            <i class="zmdi zmdi-close"></i>
                                                            Eliminar
                                                        </a>
                                                    </li>

                                                </ul>
                                            </div>

                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $(function () {
            tablaListadoDataTable();
        });
    </script>
@stop