@extends('soporte.layouts.template')
@section('title', 'Ticket ')
@section('breadcrumbs')
    @include('soporte.layouts.partials.breadcrumbs')
@endsection
@section('content')
    <?php $col = (isset($ticket) && $ticket->ticketFoto != null) ? 'col-md-7' : 'col-md-12'; ?>
    <div class="row">
        <div class="col-lg-5">
            <div class="ibox ">
                <div class="ibox-title">
                    <h5>Información de Usuario
                        <small></small>
                    </h5>
                    @include('soporte.layouts.partials.widgetbutton')
                </div>
                <div class="ibox-content">
                    {!! Form::open(['url'=>'#', 'class'=>'row informacion-usuario', 'autocomplete'=>'off']) !!}
                    <div class="col-md-12 col-sm-12">
                        <div class="row">
                            <div class="col-md-5 col-sm-5">
                                <div class="form-group ">
                                    {!! Form::label('sede_label', 'Sede', ['class' => '']) !!}
                                    {!! Form::text('sede_label',(isset($persona) ? $persona->area->sede->nombre : null),['class'=>'form-control','id'=>'sede_label','placeholder'=>'Sede','disabled'=>true]) !!}
                                </div>
                            </div>
                            <div class="col-md-7 col-sm-7">
                                {!! Form::label('area_label', 'Area', ['class' => '']) !!}
                                {!! Form::text('area_label',(isset($persona) ? $persona->area->nombre : null),['class'=>'form-control','id'=>'area_label','placeholder'=>'Area','disabled'=>true]) !!}
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12 col-sm-12">
                        <div class="form-group ">
                            {!! Form::label('cargo_label', 'Cargo', ['class' => '']) !!}
                            {!! Form::text('cargo_label',(isset($persona) ? $persona->cargo->nombre : null),['class'=>'form-control','id'=>'cargo_label','placeholder'=>'Cargo','disabled'=>true]) !!}
                        </div>
                    </div>

                    <div class="col-md-12 col-sm-12">
                        <div class="form-group ">
                            {!! Form::label('apellidos_nombres_label', 'Nombres y Apellidos', ['class' => '']) !!}
                            {!! Form::text('apellidos_nombres_label',(isset($persona) ? $persona->apellidos_nombres : null),['class'=>'form-control','id'=>'apellidos_nombres_label','placeholder'=>'Apellidos y Nombres','disabled'=>true]) !!}
                        </div>
                    </div>
                    <div class="col-md-12 col-sm-12">
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group ">
                                    {!! Form::label('email_label', 'E-mail', ['class' => '']) !!}
                                    {!! Form::text('email_label',(isset($persona) ? $persona->email : null),['class'=>'form-control','id'=>'email_label','placeholder'=>'E-mail','disabled'=>true]) !!}
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-6">
                                <div class="form-group ">
                                    {!! Form::label('telefono_label', '# Empresa', ['class' => '']) !!}
                                    {!! Form::text('telefono_label',(isset($persona) ? $persona->telefono_empresa : null),['class'=>'form-control','id'=>'telefono_label','placeholder'=>'# Empresa','disabled'=>true]) !!}
                                </div>
                            </div>
                            <div class="col-md-2 col-sm-6 p-l-0">
                                <div class="form-group ">
                                    {!! Form::label('anexo_label', 'Anexo', ['class' => '']) !!}
                                    {!! Form::text('anexo_label',(isset($persona) ? $persona->anexo : null),['class'=>'form-control','id'=>'anexo_label','placeholder'=>'Anexo','disabled'=>true]) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12 col-sm-12">
                        <div class="form-group ">
                            {!! Form::label('hace_label', 'Fecha Creación del Ticket', ['class' => '']) !!}
                            {!! Form::text('hace_label',dateTicketCarbon($ticket->ticketEstado->fecha_inicio_pendiente),['class'=>'form-control ','id'=>'hace_label','placeholder'=>'Hace','disabled'=>true]) !!}
                        </div>
                    </div>
                    <div class="col-md-12 col-sm-12">
                        <span class="d-none moment-hour-laravel">{{ $ticket->ticketEstado->fecha_inicio_pendiente }}</span>
                        <div class="form-group ">
                            {!! Form::label('inicio_ticket_label', 'Hace', ['class' => '']) !!}
                            {!! Form::text('inicio_ticket_label',(isset($ticket) ?  $ticket->ticketEstado->fecha_inicio_pendiente : null),['class'=>'form-control','id'=>'inicio_ticket_label','placeholder'=>'Inicio ticket','disabled'=>true]) !!}
                        </div>
                    </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
        <div class="col-lg-7">
            <div class="ibox ">
                <div class="ibox-title">
                    <h5>Detalle del Ticket
                        <small style="font-weight:bold"> "#{{ $ticket->codigo }}"</small>
                    </h5>
                    @include('soporte.layouts.partials.widgetbutton')
                </div>
                <div class="ibox-content">
                    {!! Form::open(['url'=>'#', 'class'=>'row informacion-usuario', 'autocomplete'=>'off']) !!}
                    <div class="col-sm-12 col-md-12">
                        <div class="row">
                            <div class="col-md-5 col-sm-12">
                                <div class="form-group ">
                                    {!! Form::label('categoria_ticket_id', 'Categoría', ['class' => '']) !!}
                                    {!! Form::text('categoria_ticket_id',(isset($ticket) ? $ticket->categoriaTicket->nombre : null),['class'=>'form-control','id'=>'categoria_ticket_id','placeholder'=>'Categoría','readonly'=>true]) !!}
                                </div>
                            </div>
                            <div class="col-md-7 col-sm-12">
                                <div class="form-group ">
                                    {!! Form::label('tipo_ticket_id', 'Tipo', ['class' => '']) !!}
                                    {!! Form::text('tipo_ticket_id',(isset($ticket) ? $ticket->tipoTicket->nombre : null),['class'=>'form-control','id'=>'tipo_ticket_id','placeholder'=>'Tipo','readonly'=>true]) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-12">
                        <div class="row">
                            <div class="col-sm-12 {{ $col }}">
                                <div class="row">
                                    <div class="col-sm-12 col-md-12">
                                        <div class="form-group ">
                                            {!! Form::label('asunto', 'Asunto', ['class' => '']) !!}
                                            {!! Form::text('asunto',(isset($ticket) ? $ticket->asunto : null),['class'=>'form-control','id'=>'asunto','placeholder'=>'Asunto','readonly'=>true]) !!}
                                        </div>
                                    </div>
                                    <div class="col-sm-12 col-md-12">
                                        <div class="form-group ">
                                            {!! Form::label('descripcion', 'Descripción', ['class' => '']) !!}
                                            {!! Form::textArea('descripcion',(isset($ticket) ? $ticket->descripcion : null),['class'=>'form-control','rows'=>'4','id'=>'descripcion','placeholder'=>'Descripción','readonly'=>true]) !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @if(isset($ticket) && $ticket->ticketFoto != null )
                                <div class="col-sm-12 col-md-5 text-center">
                                    <img src="{{ $ticket->ticketFoto->rutaFotoOriginal }}" alt="" class="w-100"
                                         style="border-radius: 5px;">
                                    <p class="fotoLink">
                                        <a href="{{ $ticket->ticketFoto->rutaFotoOriginal }}" target="_blank">
                                            Ver tamaño original
                                        </a>
                                    </p>
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="col-sm-12 col-md-12" id="wizard">
                        <h1>Asignado</h1>
                        <div class="step-content">
                            <div class="m-t-md">
                                <p>Asigna a una persona el ticket, una vez asignado se enviará un correo informado al
                                    usuario, por favor verifica si tiene el correo, en caso no lo tenga registrado,
                                    agradecería pueda actualizarlo.</p>
                                <span class="d-none " data-nticket="{{ $ticket->codigo }}"></span>
                                <div class="form-group mypointer {{ ($ticket->ticketEstado->asignado_ticket_id == null) ? '' : 'pointer-none' }}">
                                    {!! Form::select('asignado_user_id', $usuarioAsignar, (isset($ticket->ticketEstado) ? $ticket->ticketEstado->asignado_user_id  : null), ['id'=>'asignado_user_id', 'class'=>'form-control select', 'placeholder' => 'Seleccione']) !!}
                                </div>
                                <button type="button"
                                        class="btn btn-w-m btn-warning float-right {{ ($ticket->ticketEstado->asignado_ticket_id == null) ? : 'd-none' }}"
                                        id="btnTicketAsignado"
                                        data-url="{{ $estadoTicketNombre }}">
                                    Guardar
                                </button>
                            </div>
                        </div>
                        <h1>Con Incidencia</h1>
                        <div class="step-content">
                            <div class="m-t-md">
                                <div class="form-group mypointer {{ ($ticket->ticketEstado->asignado_ticket_id != null && $ticket->ticketEstado->conincidencia_ticket_id == null) ? '' : 'pointer-none' }}">
                                    {!! Form::label('mensaje_conincidencia', '¿Presenta Incidencia?', ['class' => 'f-weight']) !!}
                                    {!! Form::textArea('mensaje_conincidencia',(isset($ticket->ticketEstado) ? $ticket->ticketEstado->mensaje_conincidencia  : null),['class'=>'form-control','rows'=>'2','id'=>'mensaje_conincidencia','placeholder'=>'Describa la incidencia...']) !!}
                                </div>
                                <button type="button"
                                        class="btn btn-w-m btn-warning float-right {{ ($ticket->ticketEstado->asignado_ticket_id != null && $ticket->ticketEstado->conincidencia_ticket_id == null) ? : 'd-none' }}"
                                        id="btnTicketConIncidencia"
                                        data-url="{{ $estadoTicketNombre }}">
                                    Guardar
                                </button>
                            </div>
                        </div>
                        <h1>Atendido</h1>
                        <div class="step-content">
                            <div class="m-t-md">
                                <div class="form-group mypointer {{ ($ticket->ticketEstado->conincidencia_ticket_id != null && $ticket->ticketEstado->atendido_ticket_id == null) ? '' : 'pointer-none' }}">
                                    {!! Form::label('mensaje_atendido', 'Enviar mensaje de atención', ['class' => 'f-weight']) !!}
                                    {!! Form::textArea('mensaje_atendido',(isset($ticket->ticketEstado) ? $ticket->ticketEstado->mensaje_atendido  : null),['class'=>'form-control','rows'=>'2','id'=>'mensaje_atendido','placeholder'=>'Mensaje de atendido']) !!}
                                </div>
                                <button type="button"
                                        class="btn btn-w-m btn-warning float-right {{ ($ticket->ticketEstado->conincidencia_ticket_id != null && $ticket->ticketEstado->atendido_ticket_id == null) ? : 'd-none' }}"
                                        id="btnTicketAtentido"
                                        data-url="{{ $estadoTicketNombre }}">
                                    Guardar
                                </button>
                            </div>
                        </div>
                    </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>
    <style>
        .informacion-usuario label,
        .informacion-usuario textarea,
        .informacion-usuario select,
        .informacion-usuario input {
            font-size: 0.9em;
        }

        .wizard > .steps > ul > li {
            width: 33.3%;
        }

        .wizard > .content > .body {
            width: 100%;
        }
    </style>
@endsection
@section('scripts')
    <script>
        $(function () {
            moment.locale('es');
            $("#wizard").steps({
                enableAllSteps: true,
                enablePagination: false
                // transitionEffect: "slideLeft"
            });

            var hour_moment = $('.moment-hour-laravel');
            var ago = moment(hour_moment.text(), "YYYY-MM-DD HH:mm:ss").fromNow();
            $("#inicio_ticket_label").val(ago);

            $(document).on('click', '#btnTicketAsignado', function () {
                console.log("Click btnTicketAsignado");
                var url = $(this).data('url');
                console.log("url:::", url);

                var asignado_user = $("#asignado_user_id").val();
                var button_ = $("button[type=button]");
                button_.attr('disabled', true);
                if (asignado_user !== "") {
                    var btnTicketConIncidencia = $('#btnTicketConIncidencia');
                    $.ajax({
                        url: url,
                        type: 'POST',
                        headers: {'X-CSRF-Token': $("input[name=_token]").val()},
                        dataType: 'json',
                        data: {'asignado_user_id': asignado_user},
                        beforeSend: function () {
                        },
                        success: function (response) {
                            console.log("response:::btnTicketAsignado:::", response);
                            console.log("response:::btnTicketAsignado:::Route:::", response.route);
                            $('#btnTicketAsignado').addClass('d-none').parent().children('.mypointer').addClass('pointer-none');
                            btnTicketConIncidencia.removeClass('d-none');
                            btnTicketConIncidencia.attr('data-url', response.route);
                            btnTicketConIncidencia.parent().children('.mypointer').removeClass('pointer-none').addClass('pointer-auto');
                            toastNotify(response.message, 'success');
                        },
                        error: function (err) {
                            console.log("err:::", err.responseJSON);
                        },
                        complete: function () {
                            button_.attr('disabled', false);
                        }
                    });
                } else {
                    toastNotify('Seleccione al personal que atenderá el ticket.', 'error');
                    button_.attr('disabled', false);
                }
            });


            $(document).on('click', '#btnTicketConIncidencia', function () {
                console.log("Click btnTicketConIncidencia");
                var url = $(this).data('url');
                console.log("url:::", url);

                var mensaje_conincidencia = $("#mensaje_conincidencia").val();
                var button_ = $("button[type=button]");
                button_.attr('disabled', true);
                if (mensaje_conincidencia !== "") {
                    var btnTicketAtendido = $('#btnTicketAtentido');
                    $.ajax({
                        url: url,
                        type: 'POST',
                        headers: {'X-CSRF-Token': $("input[name=_token]").val()},
                        dataType: 'json',
                        data: {'mensaje_conincidencia': mensaje_conincidencia},
                        beforeSend: function () {
                            // $('.error-result-json').remove();
                        },
                        success: function (response) {
                            console.log("response:::btnTicketConIncidencia:::", response);
                            $('#btnTicketConIncidencia').addClass('d-none').parent().children('.mypointer').removeClass('pointer-auto').addClass('pointer-none');
                            btnTicketAtendido.attr('data-url', response.route);
                            btnTicketAtendido.removeClass('d-none');
                            btnTicketAtendido.parent().children('.mypointer').removeClass('pointer-none').addClass('pointer-auto');
                            toastNotify(response.message, 'success');
                        },
                        error: function (err) {
                            console.log("err:::", err.responseJSON);
                        },
                        complete: function () {
                            $("button[type=button]").attr('disabled', false);
                        }
                    });
                } else {
                    toastNotify('Escriba el mensaje de incidencia para reportarlo al usuario.', 'error');
                    button_.attr('disabled', false);
                }
            });

            $(document).on('click', '#btnTicketAtentido', function () {
                console.log("Click btnTicketAtentido");
                var url = $(this).data('url');
                console.log("url:::", url);

                var mensaje_atendido = $("#mensaje_atendido").val();
                var button_ = $("button[type=button]");
                button_.attr('disabled', true);
                if (mensaje_atendido !== "") {

                    $.ajax({
                        url: url,
                        type: 'POST',
                        headers: {'X-CSRF-Token': $("input[name=_token]").val()},
                        dataType: 'json',
                        data: {'mensaje_atendido': mensaje_atendido},
                        beforeSend: function () {
                            // $('.error-result-json').remove();
                        },
                        success: function (response) {
                            console.log("response:::btnTicketAtentido:::", response);
                            $('#btnTicketAtentido').addClass('d-none').parent().children('.mypointer').removeClass('pointer-auto').addClass('pointer-none');
                            toastNotify(response.message, 'success');
                        },
                        error: function (err) {
                            console.log("err:::", err.responseJSON);
                        },
                        complete: function () {
                            $("button[type=button]").attr('disabled', false);
                        }
                    });
                } else {
                    toastNotify('Escriba mensaje de atendido para finalizar con el ticket.', 'error');
                    button_.attr('disabled', false);
                }
            });

        });
    </script>
@stop

