@extends('admin.layouts.template')
@section('title', 'Tickets')
@section('content')
    @include('admin.layouts.partials.breadcrumbs')
    <div class="block-header">
        <h2>Bienvenido al centro de Soporte de ALM Operations
            <small class="message-help">
                Es muy facil de usar, si usted tiene inconvenientes, problemas o requerimiento puede generar un
                ticket, nosotros le respondemos y solucionaremos.<br>
                Si ya genero un ticket puede consultar el estado colocando el "Ticket ID" que se le envio al correo.
            </small>
        </h2>
    </div>

    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="col-md-8 col-sm-8">
                <div class="card">
                    <div class="card-header bgm-amber ch-alt m-b-20">
                        <h2>Tickets generados</h2>
                        <button class="btn mdc-bg-blue-800 btn-float">
                            <i class="zmdi zmdi-view-list"></i>
                        </button>
                    </div>

                    <div class="card-body card-padding">
                        <div class="row">
                            <div class="col-sm-12">
                                <a type="button" class="btn btn-primary m-b-10" data-toggle="modal"
                                   data-target="#createTicket">
                                    <i class="zmdi zmdi-plus-circle"></i> Generar nuevo ticket
                                </a>
                                <div class="modal fade" id="createTicket" tabindex="-1" role="dialog"
                                     aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content" style="background-color: transparent!important">
                                            <div class="modal-body">
                                                <div class="col-sm-12">
                                                    <div class="card">
                                                        <div class="card-header bgm-teal ch-alt m-b-20">
                                                            <h2>Nuevo Ticket</h2>
                                                            <span class="d-none spanUrl"
                                                                  data-url="{{ route('admin.ajax.categoriatickets') }}"></span>
                                                            <button class="btn mdc-bg-teal-800 btn-float">
                                                                <i class="zmdi zmdi-ticket-star"></i>
                                                            </button>
                                                        </div>

                                                        <div class="card-body card-padding">
                                                            <h5 class="text-danger" style="font-weight: bold;">( * ) =
                                                                Dato obligatorio</h5>
                                                            <div class="row">
                                                                {!! Form::open(['route'=>'admin.tickets.crear', 'id'=>'formTickets', 'autocomplete'=>'off', 'files'=>true]) !!}
                                                                <div class="col-sm-12 col-md-6">
                                                                    <div class="form-group fg-line {{ $errors->has('categoria_ticket_id') ? 'has-error' : '' }}">
                                                                        {!! Form::label('categoria_ticket_id', 'Categoría', ['class' => '']) !!}
                                                                        {!! Form::label('categoria_ticket_id_label', '( * )', ['class' => 'text-danger']) !!}
                                                                        {!! Form::select('categoria_ticket_id', $categoriaTickets, (isset($ticket) ? $ticket->categoria_ticket_id : null), ['id'=>'categoria_ticket_id', 'class'=>'selectpicker','data-live-search'=>'true','placeholder'=>'Seleccione']) !!}
                                                                        <span class="text-danger">{{ $errors->first('categoria_ticket_id') }}</span>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-12 col-md-6">
                                                                    <div class="form-group fg-line {{ $errors->has('tipo_ticket_id') ? 'has-error' : '' }}">
                                                                        {!! Form::label('tipo_ticket_id', 'Tipo', ['class' => '']) !!}
                                                                        {!! Form::label('tipo_ticket_id_label', '( * )', ['class' => 'text-danger']) !!}
                                                                        {!! Form::select('tipo_ticket_id', $tipoTickets, (isset($ticket) ? $ticket->tipo_ticket_id : null), ['id'=>'tipo_ticket_id', 'class'=>'selectpicker','data-live-search'=>'true','placeholder'=>"Seleccione"]) !!}
                                                                        <span class="text-danger">{{ $errors->first('tipo_ticket_id') }}</span>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-12 col-md-12">
                                                                    <div class="form-group fg-line {{ $errors->has('asunto') ? 'has-error' : '' }}">
                                                                        {!! Form::label('asunto', 'Asunto', ['class' => '']) !!}
                                                                        {!! Form::label('asunto_label', '( * )', ['class' => 'text-danger']) !!}
                                                                        {!! Form::text('asunto',(isset($ticket) ? $ticket->asunto : null),['class'=>'form-control input-sm','id'=>'nombre','placeholder'=>'Ingrese el asunto']) !!}
                                                                        <span class="text-danger">{{ $errors->first('asunto') }}</span>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-12 col-md-12">
                                                                    <div class="form-group fg-line {{ $errors->has('descripcion') ? 'has-error' : '' }}">
                                                                        {!! Form::label('descripcion', 'Descripción', ['class' => '']) !!}
                                                                        {!! Form::label('descripcion_label', '( * )', ['class' => 'text-danger']) !!}
                                                                        {!! Form::textArea('descripcion',(isset($ticket) ? $ticket->descripcion : null),['class'=>'form-control input-sm','rows'=>'3','id'=>'descripcion','placeholder'=>'Describa el inconveniente y/o problema que presentas']) !!}
                                                                        <span class="text-danger">{{ $errors->first('descripcion') }}</span>
                                                                    </div>
                                                                </div>
                                                                <div class="col-sm-12 col-md-12">
                                                                    <div class="form-group fg-line {{ $errors->has('foto') ? 'has-error' : '' }}">
                                                                        {!! Form::label('foto', 'Imágenes de evidencia', ['class' => '']) !!}
                                                                        <a href="javascript:void(0)" onclick="addFiles()" class="small text-success"><i class="zmdi zmdi-plus"></i> Agregar</a>
                                                                        <script type="text/javascript">
                                                                            function addFiles(){
                                                                                $('#contentfiles').append('<div class="row"><div class="col-md-10"><input type="file" name="foto[]" accept="image/x-png,image/jpeg" class="form-control input-sm"></div><div class="col-md-2"><a href="javascript:void(0)" onclick="$(this).closest(\'.row\').remove();" class="small text-danger"><i class="zmdi zmdi-delete"></i></a></div></div>');
                                                                            }
                                                                        </script>
                                                                        {!! Form::label('foto_label', '( * )', ['class' => 'text-danger']) !!}
                                                                        <div id="contentfiles">
                                                                        <input type="file" name="foto[]" accept="image/x-png,image/jpeg" class="form-control input-sm">
                                                                        </div>
                                                                        <span class="text-danger">{{ $errors->first('foto') }}</span>
                                                                    </div>
                                                                </div>
                                                                <!--<div class="col-sm-12 col-md-12 text-center">
                                                                    <div class="fileinput fileinput-new"
                                                                         data-provides="fileinput"
                                                                         style="padding-right: 0;">
                                                                        <div class="fileinput-preview thumbnail fileInputModify"
                                                                             data-trigger="fileinput"
                                                                             style="padding: 0;"></div>
                                                                        <div>
                                                                        <span class="btn btn-info btn-file">
                                                                            <span class="fileinput-new">Adjuntar imagen</span>
                                                                            <span class="fileinput-exists">Cambiar</span>
                                                                            <input type="file" name="foto" accept="image/x-png,image/jpeg" class="">
                                                                        </span>
                                                                            <a href="#"
                                                                               class="btn btn-warning fileinput-exists"
                                                                               data-dismiss="fileinput">Eliminar</a>
                                                                        </div>
                                                                    </div>
                                                                </div>-->
                                                                <div class="col-sm-12 col-md-12 m-t-20 text-center">
                                                                    <button type="submit" class="btn bgm-teal m-r-20"
                                                                            id="btnGenerarTicket">Generar
                                                                    </button>
                                                                    <a href="{{ route('admin.tickets.index') }}"
                                                                       class="m-l-20 btn btn-danger">
                                                                        Cancelar
                                                                    </a>
                                                                </div>
                                                                {!! Form::close() !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <table class="table table-striped">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Código</th>
                                        <th>Registro</th>
                                        <th>Asunto</th>
                                        <th>Categoría</th>
                                        <th>Estado</th>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php if(count($tickets) > 0){ $i = 0;
                                    foreach($tickets as $ticket){ $i++; ?>
                                    <tr>
                                        <td><?php echo $i; ?></td>
                                        <td><?php echo $ticket->codigo; ?></td>
                                        <td><?php echo date('d/m/y H:i', strtotime($ticket->created_at)); ?></td>
                                        <td><?php echo $ticket->asunto; ?></td>
                                        <td><?php echo $ticket->categoria; ?></td>
                                        <td><?php if(isset($ticket->atendido->nombre)){
                                                echo $ticket->atendido->nombre;
                                            }else if(isset($ticket->incidencia->nombre)){
                                                echo $ticket->incidencia->nombre;
                                            }else if(isset($ticket->asignado->nombre)){
                                                echo $ticket->asignado->nombre;
                                            }else if(isset($ticket->pendiente->nombre)){
                                                echo $ticket->pendiente->nombre;
                                            } ?></td>

                                        <td><a href="javascript:void(0);"
                                               onclick="$('#searchTicket').val('<?php echo $ticket->codigo ?>'); $('.btnSearchAjax').click();"
                                               class="btn btn-primary"><i class="zmdi zmdi-search"></i></a></td>
                                    </tr>
                                    <?php } ?>

                                    <?php }else{ ?>
                                    <tr>
                                        <td colspan="7" class="text-center">No tiene tickets generados</td>
                                    </tr>
                                    <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 col-sm-4">
                <div class="card d-none">
                    <div class="card-header bgm-blue ch-alt m-b-20">
                        <h2>Comprobar estado del Ticket</h2>
                        <button class="btn mdc-bg-blue-800 btn-float">
                            <i class="zmdi zmdi-search"></i>
                        </button>
                    </div>

                    <div class="card-body card-padding">
                        <h2 class="text-center d-none"><i class="zmdi zmdi-ticket-star zmdi-hc-4x"></i></h2>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group fg-float m-b-30">
                                    <div class="fg-line">
                                        <span class="d-none spanUrlSearchTicket"
                                              data-url="{{ route('admin.ajax.buscarticket') }}"></span>
                                        <input type="text" class="form-control input-sm" id="searchTicket">
                                        <label class="fg-label">Ticket ID</label>
                                    </div>
                                    <button class="btn btn-info btnSearchAjax"><i class="zmdi zmdi-search"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card cardDetalleTicket d-none">
                    <div class="p-20">
                        <div class="row m-b-10">
                            <div class="col-md-6 col-sm-6">
                                <strong class="d-block">Categoría</strong>
                                <small class="c-gray categoriaAjax"></small>
                            </div>
                            <div class="col-md-6 col-sm-6">
                                <strong class="d-block">Tipo</strong>
                                <small class="c-gray tipoAjax"></small>
                            </div>
                        </div>
                        <div class="row m-b-10">
                            <div class="col-md-12 col-sm-12">
                                <strong class="d-block">Asunto</strong>
                                <small class="c-gray asuntoAjax"></small>
                            </div>
                        </div>
                        <div class="row m-b-10">
                            <div class="col-md-12 col-sm-12">
                                <strong class="d-block">Descripción</strong>
                                <small class="c-gray descripcionAjax"></small>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 col-sm-12 text-center imagesfotos">

                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="timeline timelineEdit"></div>
                </div>
            </div>
        </div>
    </div>
    <style>
        .fileInputModify {
            max-height: 250px !important;
        }

        .timelineEdit {
            padding: 20px 30px 30px 85px;
        }

        .timelineEdit .t-view {
            /*border: 0;*/
        }

        .timelineEdit .t-view .tv-header {
            border: 0;
        }

        .timelineEdit .t-view .tv-body p {
            margin-bottom: 0;
        }

        .t-view[data-tv-type="pendiente"]:before {
            content: "\f1fe";
            background: #FBC02D;
            box-shadow: 0 0 0 1px #FBC02D;
        }

        .t-view[data-tv-type="pendiente"]:after {
            background: #FBC02D;
        }

        .t-view[data-tv-type="asignado"]:before {
            content: "\f205";
            background: #0288D1;
            box-shadow: 0 0 0 1px #0288D1;
        }

        .t-view[data-tv-type="asignado"]:after {
            background: #0288D1;
        }

        .t-view[data-tv-type="conincidencia"]:before {
            content: "\f161";
            background: #d32f2f;
            box-shadow: 0 0 0 1px #d32f2f;
        }

        .t-view[data-tv-type="conincidencia"]:after {
            background: #d32f2f;
        }

        .t-view[data-tv-type="atendido"]:before {
            content: "\f269";
            background: #00796B;
            box-shadow: 0 0 0 1px #00796B;
        }

        .t-view[data-tv-type="atendido"]:after {
            background: #00796B;
        }

        .growl-animated {
            bottom: 10px !important;
        }

        .growl-animated.alert-danger {
            background-color: rgba(244, 67, 54, 1);
        }

        .growl-animated.alert-success {
            background-color: rgba(76, 175, 80, 1);
        }

        .cardDetalleTicket {

        }

        .cardDetalleTicket small.c-gray {
            font-size: 14px;
        }

        /*.btnClearSearchTicket {*/
        /*position: relative;*/
        /*top: -20px;*/
        /*right: -10px;*/
        /*float: right;*/
        /*background-color: #e5e5e5;*/
        /*border-radius: 50px !important;*/
        /*z-index: 999;*/
        /*height: 40px;*/
        /*}*/

        .btnSearchAjax {
            float: right;
            margin-top: -30px;
            z-index: 10;
        }
    </style>
@endsection
@section('scripts')
    <script>
        $(function () {
            $(document).on('submit', '#formTickets', function () {
                console.log("disabled button");
                $('#btnGenerarTicket').attr('disabled', true);
            });

            $(document).on('change', "#categoria_ticket_id", function () {
                var categoria_ = $(this).val();
                console.log("change Categoria::: " + categoria_);
                if (categoria_ !== '') {
                    var url_ = $('.spanUrl').data('url') + '/' + parseInt(categoria_);
                    console.log(url_);
                    $.ajax({
                        url: url_,
                        type: 'GET',
                        dataType: 'json',
                        beforeSend: function () {
                        },
                        success: function (response) {
                            console.log('response:::', response);
                            var select = "";
                            select += '<option value="">Seleccione</option>';
                            $.each(response.data, function (key, value) {
                                select += '<option value="' + value + '">' + key + '</option>';
                            });
                            $("#tipo_ticket_id").html(select).selectpicker('refresh');
                        },
                        error: function (err) {
                            console.log("Err:::", err.responseText);
                        },
                        complete: function () {
                            console.log("complete...");
                        }
                    });
                } else {
                    var select = "";
                    select += '<option value="">Seleccione</option>';
                    $("#tipo_ticket_id").html(select).selectpicker('refresh');
                }
            });

            $(document).on('click', '.btnSearchAjax', function () {
                var ticket_ = $("#searchTicket").val();
                searchTicket(ticket_);
            });

            function searchTicket(ticket_) {
                $('.growl-animated').remove();
                $('.showMessageResultAjax').remove();
                $('.cardDetalleTicket').addClass('d-none');
                if (ticket_ !== '') {
                    $('.page-loader').css('display', 'block');
                    var url_ = $('.spanUrlSearchTicket').data('url') + '/' + ticket_;
                    $.ajax({
                        url: url_,
                        type: 'GET',
                        dataType: 'json',
                        beforeSend: function () {
                        },
                        success: function (response) {
                            if (response.data != null) {
                                console.log("no esta vacio");
                                console.log('response:::', response);
                                $('.categoriaAjax').text(response.data.categoria_ticket.nombre);
                                $('.tipoAjax').text(response.data.tipo_ticket.nombre);
                                $('.asuntoAjax').text(response.data.asunto);
                                $('.descripcionAjax').text(response.data.descripcion);
                                if (response.data.ticketFotos !== null) {

                                    for(var i=0; i<response.data.ticketFotos.length; i++){
                                        $('.imagesfotos').append('<img src="'+LA.base_url + 'web/tickets/' + response.data.ticketFotos[i].foto+'" class="imageAjax w-100" alt="">');
                                    }
                                }
                                appendEstadoTicket(response.data.ticketEstado);
                                $('.cardDetalleTicket').removeClass('d-none');
                                messageFlash('<i class="zmdi zmdi-notifications-active"></i>', response.message, 'success');
                            } else {
                                console.log(response);
                                $('.categoriaAjax').text('');
                                $('.tipoAjax').text('');
                                $('.asuntoAjax').text('');
                                $('.descripcionAjax').text('');
                                $('.imageAjax').prop('src', '');
                                messageFlash('<i class="zmdi zmdi-notifications-active"></i>', response.message, 'warning');
                            }
                        },
                        error: function (err) {
                            console.log("Err:::", err.responseText);
                        },
                        complete: function () {
                            setTimeout(function () {
                                $('.page-loader').css('display', 'none');
                            }, 1000);
                        }
                    });
                } else {
                    messageFlash('<i class="zmdi zmdi-notifications-active"></i>', 'Ingrese número de ticket, por favor', 'danger');
                }
            }

            function appendEstadoTicket(ticketEstado) {
                var div = '<div class="t-view" data-tv-type="pendiente">' +
                    '<div class="tv-header media">' +
                    '<div class="media-body p-t-5">' +
                    '<strong class="d-block">Pendiente</strong>' +
                    '<small class="c-gray d-block"><i class="zmdi zmdi-timer"></i> ' + ticketEstado.fecha_inicio_pendiente + '</small>' +
                    '<small class="c-gray d-block">' + verificarNull(ticketEstado.fecha_fin_pendiente) + '</small>' +
                    '</div>' +
                    '</div>';
                if (ticketEstado.mensaje_pendiente !== null) {
                    div += '<div class="tv-body">' +
                        '<p>' + ticketEstado.mensaje_pendiente + '</p>' +
                        '<div class="clearfix"></div>' +
                        '</div>';
                }
                div += '</div>';
                if (ticketEstado.fecha_inicio_asignado !== null) {
                    div += '<div class="t-view" data-tv-type="asignado">' +
                        '<div class="tv-header media">' +
                        '<div class="media-body p-t-5">' +
                        '<strong class="d-block">Asignado</strong>' +
                        '<small class="c-gray d-block"><i class="zmdi zmdi-timer"></i> ' + ticketEstado.fecha_inicio_asignado + '</small>' +
                        '<small class="c-gray d-block">' + verificarNull(ticketEstado.fecha_fin_asignado) + '</small>' +
                        '</div>' +
                        '</div>';
                    if (ticketEstado.mensaje_asignado !== null) {
                        div += '<div class="tv-body">' +
                            '<p>' + ticketEstado.mensaje_asignado + '</p>' +
                            '<div class="clearfix"></div>' +
                            '</div>';
                    }
                    div += '</div>';
                }
                if (ticketEstado.fecha_inicio_conincidencia !== null) {
                    div += '<div class="t-view" data-tv-type="conincidencia">' +
                        '<div class="tv-header media">' +
                        '<div class="media-body p-t-5">' +
                        '<strong class="d-block">Con Incidencia</strong>' +
                        '<small class="c-gray d-block"><i class="zmdi zmdi-timer"></i> ' + ticketEstado.fecha_inicio_conincidencia + '</small>' +
                        '<small class="c-gray d-block">' + verificarNull(ticketEstado.fecha_fin_conincidencia) + '</small>' +
                        '</div>' +
                        '</div>';
                    if (ticketEstado.mensaje_conincidencia !== null) {
                        div += '<div class="tv-body">' +
                            '<p>' + ticketEstado.mensaje_conincidencia + '</p>' +
                            '<div class="clearfix"></div>' +
                            '</div>';
                    }
                    div += '</div>';
                }
                if (ticketEstado.fecha_inicio_atendido !== null) {
                    div += '<div class="t-view" data-tv-type="atendido">' +
                        '<div class="tv-header media">' +
                        '<div class="media-body p-t-5">' +
                        '<strong class="d-block">Atendido</strong>' +
                        '<small class="c-gray d-block"><i class="zmdi zmdi-timer"></i> ' + ticketEstado.fecha_inicio_atendido + '</small>' +
                        '<small class="c-gray d-block">' + verificarNull(ticketEstado.fecha_fin_atendido) + '</small>' +
                        '</div>' +
                        '</div>';
                    if (ticketEstado.mensaje_atendido !== null) {
                        div += '<div class="tv-body">' +
                            '<p>' + ticketEstado.mensaje_atendido + '</p>' +
                            '<div class="clearfix"></div>' +
                            '</div>';
                    }
                    div += '</div>';
                }
                $('.timelineEdit').html(div);
            }

            function verificarNull(fecha) {
                return (fecha === null) ? '' : '<i class="zmdi zmdi-timer-off"></i> ' + fecha;
            }



            var isMobile = /Mobi/.test(navigator.userAgent);
            if (isMobile) {
                $('.message-help').text('Es muy facil de usar, si usted tiene inconvenientes o problemas puede generar un ticket.');
            } else {
                $('.message-help').text('Es muy facil de usar, si usted tiene inconvenientes o problemas puede generar un ticket, nosotros le respondemos y solucionaremos.\n' +
                    'Si ya genero un ticket puede consultar el estado colocando el "Ticket ID" que se le envio al correo.');
            }
        });
    </script>
@stop