@extends('admin.layouts.template')
@section('title', 'Sedes')
@section('content')
    {{--@include('admin.layouts.partials.breadcrumbs')--}}
    @if(count($sedes) > 0)
        <div class="row hidden-sm hidden-xs">
            @foreach($sedes as $sede)
                <div class="col-sm-4">
                    <a class="" href="{{ route('admin.sede.detalle',$sede->slug) }}">
                        <div class="card">

                            <div class="card-header">
                                <h2>
                                    <i class="zmdi zmdi-pin animated infinite pulse mdc-text-deep-purple-800"></i> {{ $sede->nombre }}
                                </h2>
                            </div>
                        </div>
                    </a>
                </div>
            @endforeach
        </div>

        <div class="card hidden-lg hidden-md">
            <div class="lv-header-alt clearfix m-b-30">
                <h2 class="lvh-label hidden-xs">Filtra área</h2>
                <div class="lvh-search" style="display:block">
                    <input type="search" id="searchPersona" placeholder="Filtra sede..." class="lvhs-input">
                    <i class="lvh-search-close close-search">&times;</i>
                </div>
            </div>

            <div class="card-body">
                <div class="listview">
                    <div class="lv-body contacts">
                        @foreach($sedes as $sede)
                            <a class="lv-item b-b-color line-bottom-f-l listadoPersona" href="{{ route('admin.sede.detalle',$sede->slug) }}">
                                <div class="media">
                                    <div class="pull-left">
                                        <i class="zmdi zmdi-pin zmdi-hc-2x animated infinite pulse mdc-text-deep-purple-800"></i>
                                    </div>
                                    <div class="media-body">
                                        <div class="lv-title">
                                            <strong style="font-weight: 400">{{ $sede->nombre }}</strong>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection