@extends('admin.layouts.template')
@section('title', 'Recursos Humanos')
@section('content')
    @include('admin.layouts.partials.breadcrumbs')
    @if(count($archivos) > 0)
        <div class="row ">
            @foreach($archivos as $archivo)
                <div class="col-sm-4">
                    <a class="" target="_blank" href="{{ asset('web/rrhh/'.$archivo->filename) }}">
                        <div class="card">
                            <div class="card-header">
                                <h2>{{ $archivo->original_name }}</h2>
                            </div>
                            <div class="card-body archivo-file">
                                <p class="btn-download-file">DESCARGAR</p>
                            </div>
                        </div>
                    </a>
                </div>
            @endforeach
        </div>
    @else
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body card-padding">
                        <p>Aún no hay archivos de parte de RR.HH</p>
                    </div>
                </div>
            </div>
        </div>
    @endif
    <style>
        .btn-download-file {
            text-align: center;
            background-color: #F44336;
            color: #fff;
            height: 30px;
            margin-bottom: 0;
            padding-top: 5px;
        }

        .card .card-header{
            padding: 0 !important;
            /*height: 45px;*/
        }
        .card .card-header h2 {

            text-overflow: ellipsis;
            display: block;
            width: 100%;
            display: -webkit-box;
            line-height: 1.4 !important;
            -webkit-line-clamp: 3;
            -webkit-box-orient: vertical;
            overflow: hidden;
            height: 65px;
            padding: 10px 20px !important;
        }
    </style>
@endsection
