@extends('admin.layouts.template')
@section('title', 'Perfíl')
@section('content')
    {{--@include('admin.layouts.partials.breadcrumbs')--}}
    <div class="card" id="profile-main">
        @include('admin.personas.perfil.partials.profile')

        <div class="pm-body clearfix">

            <ul class="tab-nav tn-justified">
                <li class="active waves-effect"><a href="{{ route('admin.perfil.index') }}">INFORMACIÓN</a></li>
                <li class="waves-effect"><a href="{{ route('admin.perfil.cumpleanio') }}">SALUDOS</a></li>
            </ul>

            <div class="pmb-block">
                <div class="pmbb-header">
                    <h2><i class="zmdi zmdi-account m-r-5"></i> Información Basica</h2>
                    <ul class="actions">
                        <li class="dropdown">
                            <a href="#" data-toggle="dropdown">
                                <i class="zmdi zmdi-more-vert"></i>
                            </a>

                            <ul class="dropdown-menu dropdown-menu-right">
                                <li>
                                    <a data-pmb-action="edit" href="#">Editar</a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </div>
                <div class="pmbb-body p-l-30">
                    <div class="pmbb-view">
                        <dl class="dl-horizontal">
                            <dt>Apellidos y Nombres</dt>
                            <dd>{{ existsContent($persona->apellidos_nombres) }}</dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Genero</dt>
                            <dd>{{ existsContent($persona->genero) }}</dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Cumpleaños</dt>
                            <dd class="text-uppercase">
                                {{ ($persona->fecha_nacimiento != null ) ? dateCarbon(formatDate($persona->fecha_nacimiento)) : "-" }}
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Estado Civil</dt>
                            <dd class="text-uppercase">{{ existsContent($persona->estado_civil) }}</dd>
                        </dl>
                    </div>
                    {!! Form::model($persona, ['route'=>['admin.perfil.update.basic', $persona->id], 'class'=>'formAjaxPerfilBasica']) !!}
                    <div class="pmbb-edit">
                        <dl class="dl-horizontal">
                            <dt class="p-t-10">Apellidos y Nombres</dt>
                            <dd>
                                <div class="fg-line">
                                    {!! Form::text('apellidos_nombres',(isset($persona) ? $persona->apellidos_nombres : null),['class'=>'form-control','id'=>'apellidos_nombres','placeholder'=>'Apellidos y Nombres']) !!}
                                </div>
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt class="p-t-10">Genero</dt>
                            <dd>
                                <div class="fg-line">
                                    {!! Form::select('genero', $genero, (isset($persona) ? $persona->genero : null), ['id'=>'genero', 'class'=>'form-control select']) !!}
                                </div>
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt class="p-t-10">Fecha Nacimiento</dt>
                            <dd>
                                <div class="dtp-container dropdown fg-line">
                                    {!! Form::text('fecha_nacimiento',(isset($persona) ? $persona->fecha_nacimiento : null),['class'=>'form-control', 'data-toggle'=>'dropdown', 'id'=>'fecha_nacimiento','placeholder'=>'Clic Aquí...']) !!}
                                </div>
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt class="p-t-10">Estado Civil</dt>
                            <dd>
                                <div class="fg-line">
                                    {!! Form::select('estado_civil', $estadoCivil, (isset($persona) ? $persona->estado_civil : null), ['id'=>'estado_civil', 'class'=>'form-control select']) !!}
                                </div>
                            </dd>
                        </dl>

                        <div class="m-t-30">
                            <button class="btn btn-success btn-sm btnSubmitFormPerfilBasica" type="submit">Guardar
                            </button>
                            <button data-pmb-action="reset" class="btn btn-danger btn-sm">Cancelar</button>
                        </div>
                    </div>
                    {!! Form::close() !!}

                </div>
            </div>

            <div class="pmb-block">
                <div class="pmbb-header">
                    <h2><i class="zmdi zmdi-phone m-r-5"></i> Información Contacto</h2>
                    <ul class="actions">
                        <li class="dropdown">
                            <a href="#" data-toggle="dropdown">
                                <i class="zmdi zmdi-more-vert"></i>
                            </a>

                            <ul class="dropdown-menu dropdown-menu-right">
                                <li>
                                    <a data-pmb-action="edit" href="#">Editar</a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </div>
                <div class="pmbb-body p-l-30">
                    <div class="pmbb-view">
                        <dl class="dl-horizontal">
                            <dt>Sede</dt>
                            <dd>{{ $persona->sede->nombre }}</dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Área</dt>
                            <dd>{{ $persona->area->nombre }}</dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Cargo</dt>
                            <dd>{{ $persona->cargo->nombre }}</dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>E-Mail</dt>
                            <dd>
                                @if($persona->email != null || $persona->email != "")
                                    <a href="mailto:{{$persona->email}}?subject=Saludos%20{{ encodeUriComponent($persona->nombre_apellido) }}&body=Hola,%0A%0A{{ encodeUriComponent('El motivo de este mensaje es el siguiente:') }}"
                                       target="_blank">
                                        {{$persona->email}}
                                    </a>
                                @else
                                    -
                                @endif
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Teléfono Empresa</dt>
                            <dd>
                                @if($persona->telefono_empresa != null || $persona->telefono_empresa != "")
                                    <a href="tel:{{ encodeUriComponent($persona->telefono_empresa)}} ">
                                        {{ $persona->telefono_empresa }}
                                    </a>
                                @else
                                    -
                                @endif
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Anexo</dt>
                            <dd>{{ existsContent($persona->anexo) }}</dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt>Telefono Personal</dt>
                            <dd>
                                @if($persona->telefono_personal != null || $persona->telefono_personal != "")
                                    <a href="tel:{{ encodeUriComponent($persona->telefono_personal)}} ">
                                        {{ $persona->telefono_personal }}
                                    </a>
                                @else
                                    -
                                @endif
                            </dd>
                        </dl>
                    </div>
                    {!! Form::model($persona, ['route'=>['admin.perfil.update.contact', $persona->id], 'class'=>'formAjaxPerfilContact']) !!}
                    <div class="pmbb-edit">
                        <dl class="dl-horizontal">
                            <dt class="p-t-10">E-Mail</dt>
                            <dd>
                                <div class="fg-line">
                                    {!! Form::email('email',(isset($persona) ? $persona->email : null),['class'=>'form-control','id'=>'email','placeholder'=>'E-Mail']) !!}
                                </div>
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt class="p-t-10">Teléfono Empresa</dt>
                            <dd>
                                <div class="fg-line">
                                    {!! Form::text('telefono_empresa',(isset($persona) ? $persona->telefono_empresa : null),['class'=>'form-control onlyNumber','id'=>'telefono_empresa','placeholder'=>'Teléfono Empresa','maxlength'=>9]) !!}
                                </div>
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt class="p-t-10">Anexo</dt>
                            <dd>
                                <div class="fg-line">
                                    {!! Form::text('anexo',(isset($persona) ? $persona->anexo : null),['class'=>'form-control onlyNumber','id'=>'anexo','placeholder'=>'Anexo','maxlength'=>4]) !!}
                                </div>
                            </dd>
                        </dl>
                        <dl class="dl-horizontal">
                            <dt class="p-t-10">Teléfono Personal</dt>
                            <dd>
                                <div class="fg-line">
                                    {!! Form::text('telefono_personal',(isset($persona) ? $persona->telefono_personal : null),['class'=>'form-control onlyNumber','id'=>'telefono_personal','placeholder'=>'Teléfono Personal','maxlength'=>9]) !!}
                                </div>
                            </dd>
                        </dl>
                        <div class="m-t-30">
                            <button class="btn btn-success btn-sm btnSubmitFormPerfilContact" type="submit">Guardar
                            </button>
                            <button data-pmb-action="reset" class="btn btn-danger btn-sm">Cancelar</button>
                        </div>
                    </div>
                    {!! Form::close() !!}

                </div>
            </div>

        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $(function () {
            $("#fecha_nacimiento").datetimepicker({
                format: 'DD-MM-YYYY',
                locale: 'es'
            });
        });
    </script>
@stop