@extends('admin.layouts.template')
@section('title', 'Perfíl Cumpleaños')
@section('content')
    {{--@include('admin.layouts.partials.breadcrumbs')--}}
    <div class="card c-timeline" id="profile-main">
        @include('admin.personas.perfil.partials.profile')

        <div class="pm-body clearfix">

            <ul class="tab-nav tn-justified">
                <li class="waves-effect"><a href="{{ route('admin.perfil.index') }}">INFORMACIÓN</a></li>
                <li class="active waves-effect"><a href="{{ route('admin.perfil.cumpleanio') }}">SALUDOS</a></li>
            </ul>

            <div class="timeline">
                @if(count($messages))
                    @foreach($messages as $key => $message)
                        <?php $errorImage = asset('img/profile/' . (($message->persona->genero == 'M') ? "man" : "women") . ".png"); ?>
                        <div class="t-view" data-tv-type="text">
                            <div class="tv-header media">

                                <a href="javascript:;" class="tvh-user pull-left">
                                    {{ Html::image(loadPhotoProfile($message->persona->foto,$message->persona->genero), $message->persona->apellidos_nombres,['class'=>'','onerror'=>"this.src='".$errorImage."'"]) }}
                                </a>
                                <div class="media-body p-t-5">
                                    <strong class="d-block">{{ $message->persona->apellidos_nombres }}</strong>
                                    <small class="c-gray">{{ messageDate($message->created_at) }}</small>
                                </div>

                            </div>
                            <div class="tv-body">
                                <p>{{ $message->message }}</p>
                                <div class="clearfix"></div>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="t-view" data-tv-type="image">
                        <div class="tv-header media">
                            <div class="media-body p-t-5">
                                <strong class="d-block">Aún no tienes saludos.</strong>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $(function () {

        });
    </script>
@stop