@extends('admin.layouts.template')
@section('title', 'Personas')
@section('content')
    @include('admin.layouts.partials.breadcrumbs')
    <div class="block-header" style="padding: 0 5px;">
        <h2>
            <small class="focus-me">
                Escriba parte del nombre a buscar en todas las filiales y presione en la lupita para buscar.<br>
            </small>
        </h2>
    </div>

    <div class="card">
        <div class="listview lv-bordered lv-lg">
            <div class="lv-header-alt clearfix m-b-30" style="max-height: 62px;">
                {!! Form::open(['url'=>'#', 'autocomplete'=>'off' ,'id'=>'persona-search-form']) !!}
                <h2 class="lvh-label"></h2>
                <div class="lvh-search" style="display:block">
                    <input type="search" id="name_people" placeholder="Escriba parte del nombre..." class="lvhs-input">
                </div>
                <button type="submit" class="btn bgm-teal btn-md " id="btnSearchPeople">
                    <i class="zmdi zmdi-search"></i>
                </button>
                {!! Form::close() !!}
            </div>
            <div class="lv-body add-people-ajax"></div>
        </div>
    </div>
    <div class="show-message-result"></div>
    <style>
        .lvh-search:before {
            content: "";

        }
        .lvhs-input{
            padding: 0 5px 0 10px;
        }

        #btnSearchPeople {
            float: right;
            z-index: 10;
            height: 62px;
            width: 60px;
            position: relative;
            top: -15px;
            right: -15px;
        }
        #btnSearchPeople i{
            font-size: 4rem;
        }
    </style>
@endsection
@section('scripts')
    <script>
        $(function () {
            var isMobile = /Mobi/.test(navigator.userAgent);
            if (isMobile) {
                // $('.message-mobile').text('Escriba el nombre y presione la lupita en su teclado virtual');
            } else {
                // $('.message-mobile').text('Escriba el nombre y presione enter');
            }
        });
    </script>
@stop