@extends('admin.layouts.template')
@section('title', 'Cumpleaños')
@section('content')
    @include('admin.layouts.partials.breadcrumbs')
    {{--<div class="block-header">--}}
    {{--<h2 class="hidden-sm hidden-xs">Listado de personas del área "{!! urlTexto($slug) !!}"</h2>--}}
    {{--</div>--}}

    <div class="card">

        <div class="lv-header-alt clearfix m-b-5">
            <h2 class="lvh-label hidden-xs"></h2>

            <div class="lvh-search" style="display:block">
                <input type="text" placeholder="Filtra nombre..." id="searchPersona" class="lvhs-input">
                <i class="lvh-search-close close-search">&times;</i>
            </div>
        </div>

        <div class="card-body card-padding">
            @if(count($personas) > 0)
                <div class="contacts clearfix row" style="padding-top: 20px;">
                    @foreach($personas as $persona)
                        <?php $errorImage = asset('img/profile/' . (($persona->genero == 'M') ? "man" : "women") . ".png"); ?>
                        <div class="col-md-2 col-sm-4 col-xs-6 listadoPersona {{ verificaCumple($persona->fecha_nacimiento) ? "animated infinite pulse" : "" }} ">
                            <a href="{{ route('admin.persona.detalle',$persona->slug) }}" class="ci-avatar" style="display: block;">
                                <div class="c-item">
                                    <div class="ci-avatar show-photo-profile-radius">
                                        {{ Html::image(loadPhotoProfile($persona->foto,$persona->genero), $persona->apellidos_nombres,['class'=>'p-10','onerror'=>"this.src='".$errorImage."'"]) }}
                                    </div>
                                    <div class="c-info">
                                        <strong>{{ $persona->apellidos_nombres }}</strong>
                                        <small>{{ dateCarbon($persona->fecha_nacimiento) }}</small>
                                    </div>
                                    <div class="c-footer">
                                        <button class="waves-effect"><i class="zmdi zmdi-eye"></i></button>
                                    </div>
                                </div>
                            </a>
                        </div>
                    @endforeach
                </div>
            @endif
        </div>
    </div>
@endsection