@extends('admin.layouts.template')
@section('title', 'Favoritos')
@section('content')
    @include('admin.layouts.partials.breadcrumbs')
    @if(count($favoritos) > 0)
        <div class="card">
            <div class="lv-header-alt clearfix m-b-5">
                <h2 class="lvh-label hidden-xs">Escriba el nombre</h2>
                <div class="lvh-search" style="display:block">
                    <input type="search" id="searchPersona" placeholder="Filtra nombre..." class="lvhs-input">
                    <i class="lvh-search-close close-search">&times;</i>
                </div>
            </div>

            <div class="card-body card-padding">
                <div class="contacts clearfix row"  style="padding-top: 20px;">
                    @foreach($favoritos as $favorito)
                        <?php $errorImage = asset('img/profile/' . (($favorito->persona->genero == 'M') ? "man" : "women") . ".png"); ?>
                        <div class="col-md-2 col-sm-4 col-xs-6 listadoPersona">
                            <a href="{{ route('admin.persona.detalle',$favorito->persona->slug) }}" class="ci-avatar" style="display: block;">
                                <div class="c-item">
                                    <div class="ci-avatar show-photo-profile-radius">
                                        {{ Html::image(loadPhotoProfile($favorito->persona->foto,$favorito->persona->genero), $favorito->persona->apellidos_nombres,['class'=>'p-10','onerror'=>"this.src='".$errorImage."'"]) }}
                                    </div>

                                    <div class="c-info">
                                        <strong>{{ $favorito->persona->apellidos_nombres }}</strong>
                                        {{--<small><i class="zmdi zmdi-favorite-outline"></i> Dejar de seguir</small>--}}
                                    </div>

                                    <div class="c-footer">
                                        <button class="waves-effect"><i class="zmdi zmdi-eye"></i></button>
                                    </div>
                                </div>
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @else
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body card-padding">
                        <p>Aún no has añadido favoritos, comienza buscando a una persona y agregalo</p>
                        <a href="{{ route('admin.persona.index') }}" class="btn btn-warning btn-icon-text">
                            <i class="zmdi zmdi-arrow-back"></i> Agregar persona
                        </a>
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection