@extends('admin.layouts.template')
@section('title', 'Área detalle')
@section('content')
    {{--@include('admin.layouts.partials.breadcrumbs')--}}
    {{--<div class="block-header">--}}
    {{--<h2 class="hidden-sm hidden-xs">Listado de personas del área "{!! urlTexto($slug) !!}"</h2>--}}
    {{--</div>--}}

    <div class="card">
        <div class="lv-header-alt clearfix m-b-5">
            <h2 class="lvh-label hidden-xs"></h2>

            <div class="lvh-search" style="display:block">
                <input type="text" placeholder="Filtra nombre..." id="searchPersona" class="lvhs-input">
                <i class="lvh-search-close close-search">&times;</i>
            </div>
        </div>

        <div class="card-body card-padding">
            @if(count($personas) > 0)
                <div class="contacts clearfix row" style="padding-top: 20px;">
                    @foreach($personas as $persona)
                        <div class="col-md-2 col-sm-4 col-xs-6 listadoPersona">
                            <a href="{{ route('admin.area.persona',[$slug, $persona->slug]) }}" class="ci-avatar" style="display: block;">
                                <div class="c-item">
                                    <div class="ci-avatar show-photo-profile-radius">
                                        {{ Html::image(loadPhotoProfile($persona->foto,$persona->genero), $persona->apellidos_nombres,['class'=>'p-10']) }}
                                    </div>
                                    <div class="c-info">
                                        <strong>{{ $persona->apellidos_nombres }}</strong>
                                        <small>{{ existsContent($persona->email) }}</small>
                                    </div>
                                    <div class="c-footer">
                                        <button class="waves-effect"><i class="zmdi zmdi-eye"></i></button>
                                    </div>
                                </div>
                            </a>
                        </div>
                    @endforeach
                </div>
            @endif
        </div>
    </div>
@endsection