@extends('admin.layouts.template')
@section('title', 'Compañeros')
@section('content')
    {{--@include('admin.layouts.partials.breadcrumbs')--}}
    <div class="card" id="profile-main">
        @include('admin.personas.partials.header')

        <div class="pm-body clearfix">

            <ul class="tab-nav tn-justified">
                <li class="waves-effect">
                    <a href="{{ route('admin.area.persona',[$slug, $persona->slug]) }}">Información</a>
                </li>
                <li class="active waves-effect">
                    <a href="{{ route('admin.area.persona.companieros',[$slug, $persona->slug]) }}">Compañeros</a>
                </li>
            </ul>

            <div class="pmb-block">
                @if(count($personas) > 0)
                    <div class="p-header">
                        <ul class="p-menu">
                            <li class="pm-search" style="display: block;">
                                <div class="pms-inner">
                                    <i class="zmdi zmdi-search"></i>
                                    <input type="text" id="searchPersona" placeholder="Filtra nombre...">
                                </div>
                            </li>
                        </ul>
                    </div>

                    <div class="contacts c-profile clearfix row" style="padding-top: 20px;">
                        @foreach($personas as $person)
                            <div class="col-md-3 col-sm-4 col-xs-6 listadoPersona">
                                <a href="{{ route('admin.area.persona',[$slug, $person->slug]) }}"
                                   class="ci-avatar" style="display: block;">
                                    <div class="c-item">
                                        <div class="ci-avatar show-photo-profile-radius">
                                            {{ Html::image(loadPhotoProfile($person->foto,$person->genero), $person->apellidos_nombres) }}
                                        </div>
                                        <div class="c-info">
                                            <strong>{{ $person->apellidos_nombres }}</strong>
                                            <small>{{ existsContent($persona->email) }}</small>
                                        </div>
                                        <div class="c-footer">
                                            <button class="waves-effect"><i class="zmdi zmdi-eye"></i></button>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        @endforeach
                    </div>
                @else
                    <p>Personal no cuenta con compañeros.</p>
                @endif
            </div>
        </div>
    </div>
    <style>
        .p-menu .pms-inner input[type="text"]:focus {
            width: 100%;
        }

        @media (min-width: 768px) {
            .p-menu .pms-inner input[type="text"] {
                width: 100%;
            }
        }
    </style>
@endsection
