@extends('admin.layouts.template')
@section('title', 'Areas')
@section('content')
    {{--@include('admin.layouts.partials.breadcrumbs')--}}
    @if(count($areas) > 0)
        <div class="row hidden-sm hidden-xs">
            @foreach($areas as $area)
                <div class="col-sm-4">
                    <a class="" href="{{ route('admin.area.detalle',$area->slug) }}">
                        <div class="card">
                            <div class="card-header">
                                <h2>
                                    <i class="zmdi zmdi-layers  animated infinite pulse mdc-text-deep-purple-800"></i> {{ $area->nombre }}
                                </h2>
                            </div>
                        </div>
                    </a>
                </div>
            @endforeach
        </div>

        <div class="card hidden-lg hidden-md">
            <div class="lv-header-alt clearfix m-b-30">
                <h2 class="lvh-label hidden-xs">Filtra área</h2>
                <div class="lvh-search" style="display:block">
                    <input type="search" id="searchPersona" placeholder="Filtra área..." class="lvhs-input">
                    <i class="lvh-search-close close-search">&times;</i>
                </div>
            </div>
            <div class="card-body">
                <div class="listview">
                    <div class="lv-body contacts">
                        @foreach($areas as $area)
                            <a class="lv-item b-b-color line-bottom-f-l listadoPersona"
                               href="{{ route('admin.area.detalle', $area->slug) }}">
                                <div class="media">
                                    <div class="pull-left">
                                        <i class="zmdi zmdi-layers zmdi-hc-2x animated infinite pulse mdc-text-deep-purple-800"></i>
                                    </div>
                                    <div class="media-body">
                                        <div class="lv-title">
                                            <strong style="font-weight: 400">{{ $area->nombre }}</strong>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        @endforeach
                    </div>
                </div>
            </div>

        </div>
    @else
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body card-padding">
                        <p>No hay personal registrado para está area</p>
                        <a href="{{ route('admin.index') }}" class="btn btn-warning btn-icon-text">
                            <i class="zmdi zmdi-arrow-back"></i> Volver
                        </a>
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection