<!DOCTYPE html>
<html>
<head lang="es">
    <meta charset="utf-8"/>
    <title>Tickets || ALM Operations</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    @include('layouts.admin.favicon')
    {!! Html::style('vendors/bower_components/animate.css/animate.min.css') !!}
    {!! Html::style('vendors/bower_components/material-design-iconic-font/dist/css/material-design-iconic-font.min.css') !!}
    {!! Html::style('css/app.min.1.css') !!}
    {!! Html::style('css/app.min.2.css') !!}
    {!! Html::style('css/style.css') !!}
    <link href="https://fonts.googleapis.com/css?family=K2D:400,700" rel="stylesheet">
    <style>
        * {
            font-family: 'K2D', sans-serif;
        }
    </style>
    {!! Html::script('vendors/bower_components/jquery/dist/jquery.min.js') !!}
</head>
<body class="login-content">
<div class="lc-block toggled" id="l-login">
    {!! Form::open(['route'=>'admin.login', 'id'=>'form-login', 'class'=>'form_principal_login', 'autocomplete'=>'off']) !!}
    {{ Html::image('https://sig.almoperations.com/public/assets/images/faviconalm.png','logo-almoperations',['class'=>"lcb-user"]) }}
    <div class="m-t-20"><label for="">SOPORTE TI - ALM OPERATIONS</label></div>
    <div class="input-group m-b-20">
        <span class="input-group-addon"><i class="zmdi zmdi-account"></i></span>
        <div class="fg-line">
            {!! Form::text('username',null,['class'=>'form-control text-lowercase', 'id'=>'username', 'placeholder'=>'Usuario']) !!}
        </div>
    </div>
    <div class="input-group m-b-20">
        <span class="input-group-addon"><i class="zmdi zmdi-key"></i></span>
        <div class="fg-line">
            {!! Form::password('password',['class'=>'form-control', 'id'=>'password', 'placeholder'=>'Password']) !!}
        </div>
    </div>
    <div class="clearfix"></div>
    <button type="submit" class="btn btn-login btn-danger btn-float"><i class="zmdi zmdi-arrow-forward"></i></button>
    {!! Form::close() !!}
</div>
{!! Html::script('vendors/bower_components/bootstrap/dist/js/bootstrap.min.js') !!}
{!! Html::script('vendors/bower_components/Waves/dist/waves.min.js') !!}
{!! Html::script('vendors/bootstrap-growl/bootstrap-growl.min.js') !!}
{!! Html::script('js/functions.js') !!}
<script>
    $(function () {

        $(document).on('keypress', '.onlyNumber', function (e) {
            var key = (document.all) ? e.keyCode : e.which;
            if (key === 8) return true;
            if (e.ctrlKey && key === 86) return true; //Ctrl v
            if (e.ctrlKey && key === 67) return true; //Ctrl c
            if (e.ctrlKey && key === 88) return true; //Ctrl x
            if (key < 58 && key > 47) return true;

            var patron = /\d/;
            var te = String.fromCharCode(key);
            return patron.test(te);
        });

        var isMobile = /Mobi/.test(navigator.userAgent);
        if (isMobile) {
            document.getElementById('username').type = 'number';
        }
                @if (count($errors))
        var isMobile = /Mobi/.test(navigator.userAgent);
        if (isMobile) {
            $('body').append('<div class="alert alert-danger alert-dismissible centerAlertNotify" role="alert">' +
                '<button type="button" class="close" data-dismiss="alert" aria-label="Close">' +
                '<span aria-hidden="true">&times;</span>' +
                '</button>' +
                '{{$errors["message"]}}' +
                '</div>'
            );
        } else {
            Notify("{{ $errors['message'] }}", 'danger');

            function Notify(message, type) {
                $.growl({
                    message: message
                }, {
                    element: 'body',
                    type: type,
                    allow_dismiss: true,
                    label: 'Cancel',
                    className: 'btn-xs btn-inverse',
                    placement: {
                        from: 'top',
                        align: 'right'
                    },
                    delay: 2500,
                    animate: {
                        enter: 'animated fadeIn',
                        exit: 'animated fadeOut'
                    },
                    offset: {x: 20, y: 85},
                    spacing: 10,
                    z_index: 1031
                });
            }
        }
        @endif
    });
</script>
</body>
</html>
