<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTicketEstadosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ticket_estados', function (Blueprint $table) {
            $table->increments('id');

            $table->integer('ticket_id')->unsigned()->nullable();
            $table->foreign('ticket_id')->references('id')->on('tickets')
                ->onUpdate('cascade')->onDelete('cascade');

            $table->integer('pendiente_ticket_id')->unsigned()->nullable();
            $table->foreign('pendiente_ticket_id')->references('id')->on('sub_listas')
                ->onUpdate('cascade')->onDelete('cascade');
            $table->text('mensaje_pendiente')->nullable();
            $table->dateTime('fecha_inicio_pendiente')->nullable();
            $table->dateTime('fecha_fin_pendiente')->nullable();

            $table->integer('asignado_ticket_id')->unsigned()->nullable();
            $table->foreign('asignado_ticket_id')->references('id')->on('sub_listas')
                ->onUpdate('cascade')->onDelete('cascade');
            $table->text('mensaje_asignado')->nullable();
            $table->integer('asignado_user_id')->unsigned()->nullable();
            $table->foreign('asignado_user_id')->references('id')->on('users')
                ->onUpdate('cascade')->onDelete('cascade');
            $table->dateTime('fecha_inicio_asignado')->nullable();
            $table->dateTime('fecha_fin_asignado')->nullable();

            $table->integer('conincidencia_ticket_id')->unsigned()->nullable();
            $table->foreign('conincidencia_ticket_id')->references('id')->on('sub_listas')
                ->onUpdate('cascade')->onDelete('cascade');
            $table->text('mensaje_conincidencia')->nullable();
            $table->dateTime('fecha_inicio_conincidencia')->nullable();
            $table->dateTime('fecha_fin_conincidencia')->nullable();

            $table->integer('atendido_ticket_id')->unsigned()->nullable();
            $table->foreign('atendido_ticket_id')->references('id')->on('sub_listas')
                ->onUpdate('cascade')->onDelete('cascade');
            $table->text('mensaje_atendido')->nullable();
            $table->dateTime('fecha_inicio_atendido')->nullable();
            $table->dateTime('fecha_fin_atendido')->nullable();

            $table->integer('created_user_id')->unsigned()->default(1);
            $table->foreign('created_user_id')->references('id')->on('users')
                ->onUpdate('cascade')->onDelete('cascade');

            $table->integer('updated_user_id')->unsigned()->default(1);
            $table->foreign('updated_user_id')->references('id')->on('users')
                ->onUpdate('cascade')->onDelete('cascade');

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('ticket_estados');
    }
}
