<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;

class CreateTicketsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tickets', function (Blueprint $table) {
            $table->increments('id');

//            $table->string('slug')->nullable();
//            $table->string('full_name')->nullable();
            $table->string('codigo')->nullable();
            $table->string('asunto')->nullable();
            $table->text('descripcion')->nullable();

//            $table->integer('estado_ticket_id')->unsigned()->nullable();
//            $table->foreign('estado_ticket_id')->references('id')->on('sub_listas')
//                ->onUpdate('cascade')->onDelete('cascade');

            $table->integer('categoria_ticket_id')->unsigned()->nullable();
            $table->foreign('categoria_ticket_id')->references('id')->on('sub_listas')
                ->onUpdate('cascade')->onDelete('cascade');

            $table->integer('tipo_ticket_id')->unsigned()->nullable();
            $table->foreign('tipo_ticket_id')->references('id')->on('sub_listas')
                ->onUpdate('cascade')->onDelete('cascade');

            $table->integer('created_user_id')->unsigned()->default(1);
            $table->foreign('created_user_id')->references('id')->on('users')
                ->onUpdate('cascade')->onDelete('cascade');

            $table->integer('updated_user_id')->unsigned()->default(1);
            $table->foreign('updated_user_id')->references('id')->on('users')
                ->onUpdate('cascade')->onDelete('cascade');

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('tickets');
    }
}
