<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSubListasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sub_listas', function (Blueprint $table) {
            $table->increments('id');

            $table->string('slug')->nullable();
            $table->string('nombre')->nullable();

            $table->text('descripcion')->nullable();

            $table->integer('sub_lista_id')->unsigned()->nullable();
            $table->foreign('sub_lista_id')->references('id')->on('sub_listas')
                ->onUpdate('cascade')->onDelete('cascade');

            $table->integer('lista_id')->unsigned();
            $table->foreign('lista_id')->references('id')->on('listas')
                ->onUpdate('cascade')->onDelete('cascade');

            $table->integer('created_user_id')->unsigned()->default(1);
            $table->foreign('created_user_id')->references('id')->on('users')
                ->onUpdate('cascade')->onDelete('cascade');

            $table->integer('updated_user_id')->unsigned()->default(1);
            $table->foreign('updated_user_id')->references('id')->on('users')
                ->onUpdate('cascade')->onDelete('cascade');

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('sub_listas');
    }
}
